/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vid.remote.VidDeviceRemote;
import com.zkteco.zkbiosecurity.vid.service.VidDeviceService;
import com.zkteco.zkbiosecurity.vid.service.VidParamsService;
import com.zkteco.zkbiosecurity.vid.vo.VidDeviceExportItem;
import com.zkteco.zkbiosecurity.vid.vo.VidDeviceItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VidDeviceController
extends ExportController
implements VidDeviceRemote {
    @Autowired
    private VidDeviceService vidDeviceService;
    @Autowired
    private VidParamsService vidParamsService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"vid:device"})
    public ModelAndView index() {
        this.vidDeviceService.isCreateSdkSession();
        return new ModelAndView("vid/device/vidDevice");
    }

    @RequiresPermissions(value={"vid:device:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        String ids = this.request.getParameter("ids");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.vidDeviceService.getItemById(id));
        } else if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.request.setAttribute("item", (Object)this.vidDeviceService.getItemById(ids));
        }
        this.request.setAttribute("jdkSize", (Object)System.getProperty("sun.arch.data.model"));
        this.request.setAttribute("isSupportOnvif", (Object)this.vidDeviceService.checkIsSupportOnvif());
        String type = this.request.getParameter("type");
        if (type != null) {
            if (type.equals("settings")) {
                return new ModelAndView("vid/device/editVidCommSettings");
            }
            if (type.equals("syncTime")) {
                this.getDevByIds(ids);
                return new ModelAndView("vid/device/vidDeviceSyncTime");
            }
            if (type.equals("searchDev")) {
                return new ModelAndView("vid/device/vidDeviceSearch");
            }
            if (type.equals("searchAddDev")) {
                VidDeviceItem vidDeviceItem = new VidDeviceItem();
                vidDeviceItem.setAlias(this.request.getParameter("host"));
                vidDeviceItem.setBrand(Short.valueOf(this.request.getParameter("brand")));
                vidDeviceItem.setHost(this.request.getParameter("host"));
                vidDeviceItem.setPort(Integer.valueOf(this.request.getParameter("port")));
                vidDeviceItem.setProtocol(Short.valueOf(this.request.getParameter("protocol")));
                vidDeviceItem.setSdkType(Short.valueOf(this.request.getParameter("sdkType")));
                vidDeviceItem.setAreaId(this.vidDeviceService.getAreaItemByCode("1"));
                this.request.setAttribute("item", (Object)vidDeviceItem);
                this.request.setAttribute("type", (Object)type);
            }
        }
        return new ModelAndView("vid/device/editVidDevice");
    }

    @RequiresPermissions(value={"vid:device:edit"})
    @LogRequest(module="vid_module", object="common_leftMenu_device", opType="common_op_edit", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg save(VidDeviceItem item) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        try {
            resultMsg = this.vidDeviceService.saveItem(item);
        }
        catch (Exception e) {
            this.log.info("save exception" + e);
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public DxGrid list(VidDeviceItem condition) {
        Pager pager = this.vidDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="vid_module", object="common_leftMenu_device", opType="common_op_del", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.vidDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String getBrandSupports() {
        Map vidParams = this.vidParamsService.getVidParams();
        return vidParams.getOrDefault("vid.brandSupport", String.valueOf(200));
    }

    public String validateAlias(@RequestParam(value="alias") String alias) {
        boolean ret = false;
        VidDeviceItem vidDeviceItem = this.vidDeviceService.validateDeviceAlias(alias);
        if (vidDeviceItem == null) {
            ret = true;
        }
        return String.valueOf(ret);
    }

    public String validateHost(@RequestParam(value="host") String host) {
        boolean ret = false;
        VidDeviceItem vidDeviceItem = this.vidDeviceService.validateDeviceHost(host);
        if (vidDeviceItem == null) {
            ret = true;
        }
        return String.valueOf(ret);
    }

    @LogRequest(module="vid_module", object="common_leftMenu_device", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        VidDeviceExportItem vidDeviceExportItem = new VidDeviceExportItem();
        this.setConditionValue((BaseItem)vidDeviceExportItem);
        List list = this.vidDeviceService.getExportItemList(vidDeviceExportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(list, VidDeviceExportItem.class);
    }

    public TreeItem tree() {
        List items = this.vidDeviceService.getDeviceTree(this.request.getSession().getId());
        if (items == null || items.isEmpty()) {
            TreeItem infoItem = new TreeItem();
            infoItem.setId("_");
            infoItem.setText("<span class='warningColor'>" + I18nUtil.i18nCode((String)"vid_dev_addDev", (Object[])new Object[0]) + "</span>");
            infoItem.setIm0("comm_iconAlert.png");
            items.add(infoItem);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList((Collection)items);
        return new TreeItem("0", treeItems);
    }

    @LogRequest(module="vid_module", object="common_leftMenu_device", opType="common_enable", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg enable(@RequestParam(value="ids") String ids) {
        this.vidDeviceService.enableDevice(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="vid_module", object="common_leftMenu_device", opType="common_disable", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg disable(@RequestParam(value="ids") String ids) {
        this.vidDeviceService.disableDevice(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vid:device:settings"})
    @LogRequest(module="vid_module", object="common_leftMenu_device", opType="vid_dev_communicationSetting", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg settings(VidDeviceItem vidDeviceItem) {
        ZKResultMsg msg = this.vidDeviceService.settings(vidDeviceItem);
        return I18nUtil.i18nMsg((ZKResultMsg)msg);
    }

    @RequiresPermissions(value={"vid:device:syncTime"})
    @LogRequest(module="vid_module", object="common_leftMenu_device", opType="common_dev_syncTime", requestParams={"alias"}, opContent="common_dev_name")
    public String syncTime() {
        String ids = this.request.getParameter("devIds");
        List devList = this.vidDeviceService.findByIdIn(Arrays.asList(ids.split(",")));
        if (devList != null && !devList.isEmpty()) {
            String msgStr = "";
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
            VidDeviceItem dev = null;
            int len = devList.size();
            for (int i = 0; i < len; ++i) {
                dev = (VidDeviceItem)devList.get(i);
                int total = (int)((float)(i + 1) / (float)devList.size() * 100.0f);
                msgStr = this.vidDeviceService.syncTime(dev);
                this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + " : " + msgStr + "...<br/>"));
            }
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        return "true";
    }

    public ZKResultMsg validDevCount(VidDeviceItem device) {
        ZKResultMsg ret = new ZKResultMsg();
        try {
            ret = this.vidDeviceService.validDevCount(device);
        }
        catch (Exception e) {
            this.log.info("validDevCount exception" + e);
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg getAllIPSn() {
        Map devInfo = this.vidDeviceService.getAllIPSn();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devInfo));
    }

    public String getDevByEnabled() {
        int ret = 0;
        String enabled = (String)StringUtils.defaultIfEmpty((CharSequence)this.request.getParameter("enabled"), (CharSequence)"true");
        List vidDeviceItems = this.vidDeviceService.getItemByEnabled(Boolean.valueOf(enabled));
        if (vidDeviceItems != null && vidDeviceItems.size() > 0) {
            ret = vidDeviceItems.size();
        }
        return ret + "";
    }

    public String getDevByIds(@RequestParam(value="ids") String ids) {
        String type = this.request.getParameter("type");
        if (type != null && !type.isEmpty()) {
            List list = this.vidDeviceService.findByIdIn(Arrays.asList(ids.split(",")));
            StringBuffer disabledDevName = new StringBuffer("");
            StringBuffer offlineDevName = new StringBuffer("");
            StringBuffer devName = new StringBuffer("");
            StringBuffer retIds = new StringBuffer();
            for (VidDeviceItem vidDevice : list) {
                if (vidDevice.getEnabled().booleanValue()) {
                    if (this.vidDeviceService.isDeviceOnline(vidDevice, false)) {
                        devName.append(vidDevice.getAlias()).append(",");
                        retIds.append(vidDevice.getId()).append(",");
                        continue;
                    }
                    offlineDevName.append(vidDevice.getAlias()).append(",");
                    continue;
                }
                disabledDevName.append(vidDevice.getAlias()).append(",");
            }
            this.request.setAttribute("retIds", (Object)(retIds.toString().equals("") ? "" : retIds.substring(0, retIds.length() - 1)));
            this.request.setAttribute("devicesName", (Object)(devName.toString().equals("") ? "" : devName.substring(0, devName.length() - 1)));
            this.request.setAttribute("disabledDevName", (Object)(disabledDevName.toString().equals("") ? "" : disabledDevName.substring(0, disabledDevName.length() - 1)));
            this.request.setAttribute("offlineDevName", (Object)(offlineDevName.toString().equals("") ? "" : offlineDevName.substring(0, offlineDevName.length() - 1)));
            return type;
        }
        return null;
    }

    public ZKResultMsg searchDev() {
        ZKResultMsg ret = new ZKResultMsg();
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("nowTime", this.request.getParameter("nowTime"));
        if ("64".equals(System.getProperty("sun.arch.data.model"))) {
            ret.setMsg("vid_dev_sdkx64");
            ret.setRet("500");
            ret.setData(infoMap);
            return I18nUtil.i18nMsg((ZKResultMsg)ret);
        }
        List devMap = this.vidDeviceService.searchDev();
        infoMap.put("devCount", devMap.size());
        infoMap.put("devData", devMap);
        infoMap.put("isSupportOnvif", this.vidDeviceService.checkIsSupportOnvif());
        return new ZKResultMsg(infoMap);
    }
}

