/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.client.service;

import com.zkteco.zkbiosecurity.att.enums.AttRuleEnum;
import com.zkteco.zkbiosecurity.att.service.AttCloudMessageSendService;
import com.zkteco.zkbiosecurity.att.vo.AttCloudRuleItem;
import com.zkteco.zkbiosecurity.att.vo.AttRecordItem;
import com.zkteco.zkbiosecurity.att.vo.AttTransactionItem;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.license.provider.BaseLicenseProvider;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttCloudMessageSendServiceImpl
implements AttCloudMessageSendService {
    private static final Logger log = LoggerFactory.getLogger(AttCloudMessageSendServiceImpl.class);
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;
    @Autowired
    private BaseLicenseProvider baseLicenseProvider;

    public void sendRuleToCloud(Map<String, String> params) {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.isActiveLicense()) {
            try {
                AttCloudRuleItem attCloudRuleItem = new AttCloudRuleItem();
                attCloudRuleItem.setAttCountConvertHour(params.get(AttRuleEnum.Hour.getKey()));
                attCloudRuleItem.setAttCountConvertOneHour(params.get(AttRuleEnum.OneHour.getKey()));
                attCloudRuleItem.setAttCountConvertHalfHour(params.get(AttRuleEnum.HalfAnHour.getKey()));
                attCloudRuleItem.setAttCountConvertDay(params.get(AttRuleEnum.Day.getKey()));
                attCloudRuleItem.setAttCountConvertOneDay(params.get(AttRuleEnum.OneDay.getKey()));
                attCloudRuleItem.setAttCountConvertHalfDay(params.get(AttRuleEnum.HalfAnDay.getKey()));
                attCloudRuleItem.setAttCountConvertAbsentDay(params.get(AttRuleEnum.AbsentDay.getKey()));
                attCloudRuleItem.setAttCountConvertDecimal(params.get(AttRuleEnum.Decimal.getKey()));
                ZKMessage message = new ZKMessage();
                message.setAppId(this.baseLicenseService.getAppId());
                message.setModuleCode("att");
                message.setMessageId("attCloudRuleServiceImpl#saveCloudRule");
                message.setListContent(Collections.singletonList(attCloudRuleItem));
                this.baseLicenseClientService.sendMessage(message);
            }
            catch (Exception e) {
                log.error("AttCloudMessageSendService sendRuleToCloud Error", (Throwable)e);
            }
        }
    }

    public void asyncPushTransactionToCloud(List<AttTransactionItem> attTransactionItemList) {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.isActiveLicense() && !CollectionUtil.isEmpty(attTransactionItemList)) {
            CompletableFuture.runAsync(() -> {
                List attTransactionItemsList = CollectionUtil.split((Collection)attTransactionItemList, (int)30);
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setAppId(this.baseLicenseService.getAppId());
                zkMessage.setModuleCode("att");
                zkMessage.setMessageId("attCloudTransactionHandleMessage#handleAttTransactionMessage");
                attTransactionItemsList.forEach(attTransactionItems -> {
                    zkMessage.setListContent(attTransactionItems);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                });
            });
        }
    }

    public void asyncPushRecordToCloud(List<AttRecordItem> attRecordItemList) {
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && this.isActiveLicense() && !CollectionUtil.isEmpty(attRecordItemList)) {
            CompletableFuture.runAsync(() -> {
                List attRecordItemsList = CollectionUtil.split((Collection)attRecordItemList, (int)30);
                ZKMessage zkMessage = new ZKMessage();
                zkMessage.setAppId(this.baseLicenseService.getAppId());
                zkMessage.setModuleCode("att");
                zkMessage.setMessageId("attCloudRecordHandleMessage#handleAttRecordMessage");
                attRecordItemsList.forEach(attRecordItems -> {
                    zkMessage.setListContent(attRecordItems);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                });
            });
        }
    }

    public boolean isActiveLicense() {
        List activeModuleCodeList = this.baseLicenseProvider.getActiveModuleLIist();
        return activeModuleCodeList.contains("att");
    }
}

