/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.push.processor;

import com.alibaba.fastjson.JSON;
import com.zkteco.zkbiosecurity.adms.cache.AdmsCacheManager;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.BaseProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.utils.DeviceDataUtil;
import com.zkteco.zkbiosecurity.adms.distributor.utils.RequestUtil;
import com.zkteco.zkbiosecurity.adms.service.Adms4PosIDService;
import com.zkteco.zkbiosecurity.adms.service.AdmsAuthDeviceService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDevCmdService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDeviceService;
import com.zkteco.zkbiosecurity.adms.vo.AdmsAuthDeviceItem;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PosIDPushProcessor
extends BaseProcessor {
    @Autowired
    private AdmsDeviceService admsDeviceService;
    @Autowired
    private AdmsAuthDeviceService admsAuthDeviceService;
    @Autowired
    private AdmsCacheManager admsCacheManager;
    @Autowired(required=false)
    private Adms4PosIDService adms4PosIDService;
    @Autowired
    private AdmsDevCmdService admsDevCmdService;

    @Override
    public String handleReqData(ChannelHandlerContext ctx, HttpRequest httpRequest, String sn) throws Exception {
        String uri = httpRequest.getUri();
        URI uriObj = new URI(uri);
        String requestPath = uriObj.getPath();
        this.printLog(sn, uri);
        boolean firstReq = uri.contains("options") && uri.contains("pushver");
        String rs = "UNKNOWN DEVICE";
        if (firstReq) {
            String clientIP = this.getClientIP(ctx, httpRequest);
            int serverPort = this.getServerPort(httpRequest);
            String pushver = RequestUtil.getParams(uri, "pushver");
            String deviceName = RequestUtil.getParams(uri, "deviceName");
            String language = RequestUtil.getParams(uri, "language");
            String deviceType = "posid";
            String fireVer = RequestUtil.getParams(uri, "fireVer");
            rs = this.dealFirstReq(sn, pushver, clientIP, serverPort, language, deviceName, deviceType, fireVer);
        } else {
            boolean exist = this.admsDeviceService.existDevice(sn);
            if (exist) {
                switch (requestPath) {
                    case "/iclock/cdata": {
                        String table = RequestUtil.getParams(uri, "table");
                        rs = this.posCdataUpload(sn, table, httpRequest, uri);
                        break;
                    }
                    case "/iclock/getrequest": {
                        rs = this.getRequest(sn, uri);
                        break;
                    }
                    case "/iclock/posdevicecmd": {
                        String data = this.getContentData(httpRequest, "UTF-8");
                        rs = this.deviceCmd(sn, data);
                        break;
                    }
                }
            }
        }
        return rs;
    }

    private String getRequest(String sn, String uri) {
        String rs = "OK";
        this.admsDeviceService.updateDevOperateState(sn, "GET_RT_LOG", "0");
        String cmd = this.admsDeviceService.getCmd(sn, 10);
        if (StringUtils.isNotBlank((CharSequence)cmd)) {
            rs = cmd;
        }
        return rs;
    }

    private String deviceCmd(String sn, String data) {
        return this.admsDevCmdService.devReturnCmd(sn, data);
    }

    private String posCdataUpload(String sn, String table, HttpRequest request, String uri) {
        String flag = "OK";
        String data = "";
        if ("options".equals(table)) {
            data = this.getContentData(request, "UTF-8");
            this.log.info("optons data=" + data);
            String[] cmdReturnLine = data.trim().split(",");
            Map<String, String> devOptions = DeviceDataUtil.getAttOptions(cmdReturnLine);
            devOptions.put("SN", sn);
            this.adms4PosIDService.updateDeviceOptions(devOptions);
        } else if ("POSREQUEST".equalsIgnoreCase(table)) {
            data = this.getContentData(request, "UTF-8");
            flag = this.adms4PosIDService.onLineConsume(sn, data);
        } else if ("OfflineConsumRecord".equalsIgnoreCase(table)) {
            data = this.getContentData(request, "UTF-8");
            flag = this.adms4PosIDService.offlineConsum(sn, data);
        } else if ("POSREBACK".equalsIgnoreCase(table)) {
            data = this.getContentData(request, "UTF-8");
            flag = this.adms4PosIDService.errorRecoveryData(sn, data);
        } else if ("POSQUERY".equals(table)) {
            data = this.getContentData(request, "UTF-8");
            flag = this.adms4PosIDService.posQuery(sn, data);
        }
        return flag;
    }

    private String dealFirstReq(String sn, String pushver, String clientIP, int serverPort, String language, String deviceName, String deviceType, String fireVer) {
        AdmsAuthDeviceItem authInfo = this.admsAuthDeviceService.getAuthDeviceInfo(sn);
        String retInfo = "";
        if (authInfo != null && authInfo.getAuthFlag() != null && authInfo.getAuthFlag().booleanValue()) {
            Map<String, String> deviceOptions = this.createPosDeviceOpt(sn, language, deviceName, clientIP, serverPort, fireVer, pushver, "utf-8");
            retInfo = this.admsDeviceService.regPosIDDevice(sn, deviceOptions);
        } else {
            this.log.info("pos device sn=" + sn + " no auth ,request reject");
            if (authInfo == null || !authInfo.getIp().equals(clientIP)) {
                String ipAddress = clientIP;
                String netMask = "";
                String gateway = "";
                String mac = "";
                String server = "";
                AdmsAuthDeviceItem item = new AdmsAuthDeviceItem(ipAddress, mac, netMask, gateway, sn, deviceType, server, deviceName);
                this.admsAuthDeviceService.setAuthDeviceInfo(item);
            }
            retInfo = "UNKNOWN DEVICE";
        }
        return retInfo;
    }

    private Map<String, String> createPosDeviceOpt(String sn, String language, String deviceName, String clientIP, int serverPort, String fireVer, String pushver, String charCode) {
        String devInfo = this.admsCacheManager.getDeviceInfo(sn);
        HashMap<String, String> optionsJson = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)devInfo)) {
            optionsJson.put("SN", sn);
            optionsJson.put("ErrorDelay", "30");
            optionsJson.put("DeviceType", "posid");
            optionsJson.put("language", language);
            optionsJson.put("~DeviceName", deviceName);
            optionsJson.put("CommType", "3");
            optionsJson.put("IPAddress", clientIP + "");
            optionsJson.put("IpPort", serverPort + "");
            optionsJson.put("fireVer", fireVer);
            optionsJson.put("pushVer", pushver);
            optionsJson.put("charCode", charCode);
            optionsJson.put("enabled", "true");
        } else {
            optionsJson = (Map)JSON.parseObject((String)devInfo, Map.class);
        }
        return optionsJson;
    }
}

