/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.push.processor;

import com.alibaba.fastjson.JSON;
import com.zkteco.zkbiosecurity.adms.bean.Adms2InsDevUploadInfo;
import com.zkteco.zkbiosecurity.adms.cache.AdmsCacheManager;
import com.zkteco.zkbiosecurity.adms.distributor.push.PushResponse;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.BaseProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.utils.DeviceDataUtil;
import com.zkteco.zkbiosecurity.adms.distributor.utils.JSONObjectUtil;
import com.zkteco.zkbiosecurity.adms.distributor.utils.RequestUtil;
import com.zkteco.zkbiosecurity.adms.service.Adms4InsService;
import com.zkteco.zkbiosecurity.adms.service.AdmsAuthDeviceService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDevCmdService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDeviceService;
import com.zkteco.zkbiosecurity.adms.vo.AdmsAuthDeviceItem;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InsPushProcessor
extends BaseProcessor {
    @Autowired
    private AdmsDeviceService admsDeviceService;
    @Autowired
    private AdmsAuthDeviceService admsAuthDeviceService;
    @Autowired(required=false)
    private Adms4InsService adms4InsService;
    @Autowired
    private AdmsDevCmdService admsDevCmdService;
    @Autowired
    private AdmsCacheManager admsCacheManager;

    @Override
    public String handleReqData(ChannelHandlerContext ctx, HttpRequest httpRequest, String sn) throws Exception {
        boolean exist;
        String uri = httpRequest.uri();
        URI uriObj = new URI(uri);
        String requestPath = uriObj.getPath();
        String clientIP = this.getClientIP(ctx, httpRequest);
        this.printLog(sn, uri);
        boolean firstReq = uri.contains("options") && uri.contains("pushver") && uri.contains("language");
        String rs = "UNKNOWN DEVICE";
        if (firstReq) {
            String language = RequestUtil.getParams(uri, "language");
            int serverPort = this.getServerPort(httpRequest);
            String serverHost = this.getServerHostAddr(httpRequest);
            String pushOptionsFlag = RequestUtil.getParams(uri, "PushOptionsFlag");
            String pushver = RequestUtil.getParams(uri, "pushver");
            rs = this.dealFirstReq(sn, pushver, language, clientIP, serverPort, pushOptionsFlag, serverHost);
        } else if (this.admsDeviceService.isAuthIp(clientIP) && (exist = this.admsDeviceService.existDevice(sn))) {
            if (requestPath.startsWith("/iclock/cdata")) {
                String table = RequestUtil.getParams(uri, "table");
                String stamp = RequestUtil.getParams(uri, "Stamp");
                rs = this.insCdataUpload(sn, table, stamp, httpRequest, uri);
            } else if (requestPath.startsWith("/iclock/getrequest")) {
                rs = this.getRequest(sn, uri);
            } else if (requestPath.startsWith("/iclock/devicecmd")) {
                String data = this.getContentData(httpRequest, this.getEncoding(sn));
                rs = this.deviceCmd(sn, data);
            } else if (!requestPath.startsWith("/iclock/BioSecurityFile") && requestPath.startsWith("/iclock/downloadFile")) {
                String path = RequestUtil.getParams(uri, "path");
                httpRequest.setUri(path);
                PushResponse.sendRedirect(ctx, httpRequest);
                rs = "";
            }
        }
        return rs;
    }

    public String dealFirstReq(String sn, String pushver, String language, String ip, int port, String pushOptionsFlag, String serverHost) {
        this.log.info("ins device options request.....sn=" + sn);
        AdmsAuthDeviceItem authInfo = this.admsAuthDeviceService.getAuthDeviceInfo(sn);
        String retInfo = "UNKNOWN DEVICE";
        this.admsDeviceService.setDevEncoding("ins", sn, language);
        if (authInfo != null && authInfo.getAuthFlag() != null && authInfo.getAuthFlag().booleanValue()) {
            Map<String, String> deviceOptions = this.createInsDeviceOpt(sn, pushver, language, ip, port, pushOptionsFlag, serverHost);
            retInfo = this.admsDeviceService.regInsDevice(sn, deviceOptions);
        } else {
            this.log.info("ins device sn=" + sn + " no auth ,request reject");
            if (authInfo == null || !authInfo.getIp().equals(ip)) {
                String ipAddress = ip;
                String netMask = "";
                String gateway = "";
                String mac = "";
                String deviceType = "ins";
                String deviceName = "";
                String server = "";
                AdmsAuthDeviceItem item = new AdmsAuthDeviceItem(ipAddress, mac, netMask, gateway, sn, deviceType, server, deviceName);
                this.admsAuthDeviceService.setAuthDeviceInfo(item);
            }
        }
        return retInfo;
    }

    private Map<String, String> createInsDeviceOpt(String sn, String pushver, String language, String ip, int port, String pushOptionsFlag, String serverHost) {
        String devInfo = this.admsCacheManager.getDeviceInfo(sn);
        HashMap<String, String> optionsJson = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)devInfo)) {
            optionsJson.put("SN", sn);
            optionsJson.put("language", language);
            optionsJson.put("ATTLOGStamp", "0");
            optionsJson.put("OPERLOGStamp", "0");
            optionsJson.put("BIODATAStamp", "0");
            optionsJson.put("ATTPHOTOStamp", "0");
            optionsJson.put("ErrorDelay", "60");
            optionsJson.put("Delay", "2");
            optionsJson.put("TransTimes", "00:00\t14:00");
            optionsJson.put("TransInterval", "1");
            optionsJson.put("TransFlag", "111111111111");
            optionsJson.put("TimeZone", "8");
            optionsJson.put("Realtime", "1");
            optionsJson.put("Encrypt", "0");
            optionsJson.put("DeviceType", "ins");
            optionsJson.put("ServerVer", "adms2.0");
            optionsJson.put("language", language);
            optionsJson.put("~DeviceName", sn);
            optionsJson.put("CommType", "3");
            optionsJson.put("IPAddress", ip);
            optionsJson.put("RegDeviceType", "");
            optionsJson.put("IpPort", port + "");
            optionsJson.put("PushOptionsFlag", pushOptionsFlag == null ? "0" : pushOptionsFlag);
            optionsJson.put("ServerHost", serverHost);
            optionsJson.put("enabled", "true");
            optionsJson.put("SupportPing", "1");
        } else {
            optionsJson = (Map)JSON.parseObject((String)devInfo, Map.class);
        }
        return optionsJson;
    }

    private String getRequest(String sn, String uri) {
        String info;
        String rs = "OK";
        String cmd = this.admsDeviceService.getCmd(sn, 10);
        if (StringUtils.isNotBlank((CharSequence)cmd)) {
            rs = cmd;
        }
        if (StringUtils.isNotBlank((CharSequence)(info = RequestUtil.getParams(uri, "INFO")))) {
            this.insUploadInfo(sn, info);
        }
        return rs;
    }

    private String deviceCmd(String sn, String data) {
        return this.admsDevCmdService.devReturnCmd(sn, data);
    }

    public String insCdataUpload(String sn, String table, String stamp, HttpRequest request, String uri) {
        String flag = "OK";
        String data = "";
        if ("options".equals(table)) {
            data = this.getContentData(request, this.getEncoding(sn));
            this.log.info("optons data=" + data);
            String[] cmdReturnLine = data.trim().split(",");
            Map<String, String> devOptions = DeviceDataUtil.getAttOptions(cmdReturnLine);
            devOptions.put("SN", sn);
            this.adms4InsService.updateDeviceOptions(devOptions);
        } else if ("ATTLOG".equals(table)) {
            data = this.getContentData(request, this.getEncoding(sn));
            this.admsDeviceService.saveInsLog(sn, data, stamp);
        } else if ("ATTPHOTO".equals(table)) {
            data = this.getInsPhotoDataInfo((HttpContent)request);
            this.admsDeviceService.saveInsPhoto(sn, data, stamp);
        } else if ("OPERLOG".equals(table)) {
            data = this.getContentData(request, this.getEncoding(sn));
            if (data.startsWith("USER") || data.startsWith("FP") || data.startsWith("FACE") || data.startsWith("USERPIC") || data.startsWith("BIOPHOTO")) {
                this.admsDeviceService.setInsOperLog(sn, data, stamp);
            } else if (data.contains("OPLOG")) {
                // empty if block
            }
        } else if ("BIODATA".equals(table)) {
            data = this.getContentData(request, this.getEncoding(sn));
            this.admsDeviceService.setInsBioData(sn, data, stamp);
        } else if ("RemoteAtt".equals(table)) {
            String pin = RequestUtil.getParams(uri, "PIN");
            flag = this.admsDeviceService.remoteAtt(sn, pin);
        }
        return flag;
    }

    private String getInsPhotoDataInfo(HttpContent request) {
        HttpContent httpContent = request;
        ByteBuf contentByteBuf = httpContent.content();
        contentByteBuf.readableBytes();
        int bufLen = contentByteBuf.readableBytes();
        byte[] bufArray = new byte[bufLen];
        contentByteBuf.readBytes(bufArray);
        String data = new String(bufArray);
        if (StringUtils.isNotBlank((CharSequence)data)) {
            String[] headArray = data.split("CMD=uploadphoto", 2);
            JSONObject jsonData = new JSONObject();
            Map<String, String> preInfoMap = DeviceDataUtil.formateStrToMap(headArray[0], "\n");
            for (String key : preInfoMap.keySet()) {
                JSONObjectUtil.setKeyValue(jsonData, key, preInfoMap.get(key));
            }
            int photoBufLength = Integer.parseInt(preInfoMap.get("size"));
            byte[] fileDataBytesBase64 = Base64.encodeBase64((byte[])ArrayUtils.subarray((byte[])bufArray, (int)(bufLen - photoBufLength), (int)(bufLen - 1)));
            String fileDataStrBase64 = new String(fileDataBytesBase64);
            JSONObjectUtil.setKeyValue(jsonData, "photo", fileDataStrBase64);
            return jsonData.toString();
        }
        return "";
    }

    private void insUploadInfo(String sn, String info) {
        String[] devInfoArray = info.split(",");
        Adms2InsDevUploadInfo devUploadInfo = new Adms2InsDevUploadInfo();
        devUploadInfo.setSn(sn);
        devUploadInfo.setFwVersion(devInfoArray[0]);
        devUploadInfo.setUsercCount(Integer.valueOf(devInfoArray[1]));
        devUploadInfo.setFpCount(Integer.valueOf(devInfoArray[2]));
        devUploadInfo.setTransactionCount(Integer.valueOf(devInfoArray[3]));
        devUploadInfo.setIpAddress(devInfoArray[4]);
        devUploadInfo.setFpVersion(devInfoArray[5]);
        devUploadInfo.setFaceVersion(devInfoArray[6]);
        devUploadInfo.setFaceCount(Integer.valueOf(devInfoArray[8]));
        devUploadInfo.setInsSupportFunList(devInfoArray[9]);
        if (this.adms4InsService != null) {
            this.adms4InsService.uploadDevInfo(devUploadInfo);
        }
        this.admsDeviceService.updateInsLoadInfo(devUploadInfo);
    }

    public String getEncoding(String sn) {
        return this.admsDeviceService.getDevEncoding(sn);
    }
}

