/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.push.processor;

import com.zkteco.zkbiosecurity.adms.bean.DeviceDoorState;
import com.zkteco.zkbiosecurity.adms.cache.AdmsCacheManager;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.BaseProcessor;
import com.zkteco.zkbiosecurity.adms.distributor.utils.DeviceDataUtil;
import com.zkteco.zkbiosecurity.adms.distributor.utils.JSONObjectUtil;
import com.zkteco.zkbiosecurity.adms.distributor.utils.RequestUtil;
import com.zkteco.zkbiosecurity.adms.service.Adms4AccService;
import com.zkteco.zkbiosecurity.adms.service.AdmsAuthDeviceService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDevCmdService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDeviceService;
import com.zkteco.zkbiosecurity.adms.service.AdmsParamsService;
import com.zkteco.zkbiosecurity.adms.vo.AdmsAuthDeviceItem;
import com.zkteco.zkbiosecurity.adms.vo.AdmsDevCmdItem;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@Component
public class AccPushProcessor
extends BaseProcessor {
    @Autowired
    private AdmsDeviceService admsDeviceService;
    @Autowired
    private AdmsCacheManager admsCacheManager;
    @Autowired
    private AdmsDevCmdService admsDevCmdService;
    @Autowired
    private AdmsAuthDeviceService admsAuthDeviceService;
    @Autowired(required=false)
    private Adms4AccService adms4AccService;
    @Autowired
    private AdmsParamsService admsParamsService;

    @Override
    public String handleReqData(ChannelHandlerContext ctx, HttpRequest httpRequest, String sn) throws Exception {
        String data = this.getContentData(httpRequest, "UTF-8");
        String cookieStr = httpRequest.headers().get("Cookie");
        int port = this.getServerPort(httpRequest);
        String token = "";
        if (StringUtils.isNotBlank((CharSequence)cookieStr)) {
            token = cookieStr.split("=")[1];
        }
        String rs = "OK";
        String uri = httpRequest.getUri();
        URI uriObj = new URI(uri);
        String requestPath = uriObj.getPath();
        this.printLog(sn, uri);
        String sessionId = ctx.channel().id().asLongText();
        String options = RequestUtil.getParams(uri, "options");
        String clientIP = this.getClientIP(ctx, httpRequest);
        if ("all".equals(options)) {
            rs = rs + "\nPushProtVer=3.1.2";
            String pushOptionsFlag = RequestUtil.getParams(uri, "PushOptionsFlag");
            if (StringUtils.isNotEmpty((CharSequence)pushOptionsFlag) && "1".equals(pushOptionsFlag)) {
                rs = rs + "\nPushOptionsFlag=" + pushOptionsFlag;
            }
        } else if ("/iclock/registry".equals(requestPath)) {
            rs = this.registry(sn, data, port, sessionId);
        } else if (this.admsDeviceService.isAuthIp(clientIP)) {
            switch (requestPath) {
                case "/iclock/push": {
                    rs = this.push(sn);
                    break;
                }
                case "/iclock/cdata": {
                    rs = this.cdata(sn, uri, data, port, sessionId);
                    break;
                }
                case "/iclock/getrequest": {
                    rs = this.getRequest(sn, token);
                    break;
                }
                case "/iclock/devicecmd": {
                    rs = this.deviceCmd(sn, token, data);
                    break;
                }
                case "/iclock/rtdata": {
                    rs = this.rtdata(sn, RequestUtil.getParams(uri, "type"));
                    break;
                }
                case "/iclock/querydata": {
                    Integer actualCount = StringUtils.isEmpty((CharSequence)data) ? 0 : data.split("\r\n").length;
                    rs = this.querydata(sn, RequestUtil.getParams(uri, "tablename"), RequestUtil.getParams(uri, "count"), actualCount, RequestUtil.getParams(uri, "type"), data, RequestUtil.getParams(uri, "datafmt"), RequestUtil.getParams(uri, "cmdid"), RequestUtil.getParams(uri, "packcnt"), RequestUtil.getParams(uri, "packidx"), port, sessionId);
                    break;
                }
                case "/iclock/rtlog": {
                    rs = this.rtlog(sn, data);
                    break;
                }
                case "/iclock/rtstate": {
                    rs = this.rtstate(sn, data);
                    break;
                }
                case "/iclock/ping": {
                    rs = this.heartbeat(sn, data, token);
                    break;
                }
                case "/iclock/file": {
                    String fileseq = RequestUtil.getParams(uri, "fileseq");
                    String contenttype = RequestUtil.getParams(uri, "contenttype");
                    String url = RequestUtil.getParams(uri, "url");
                    String datacode = RequestUtil.getParams(uri, "datacode");
                    if (fileseq != null && "tgz".equals(contenttype) || url == null) break;
                    rs = this.downFile(sn, datacode, url);
                    break;
                }
            }
        } else {
            rs = "406";
        }
        return rs;
    }

    private String downFile(String sn, String datacode, String fileUrl) {
        boolean isB64Code = true;
        if (StringUtils.isNotBlank((CharSequence)datacode) && "original".equals(datacode)) {
            isB64Code = false;
        }
        String rs = null;
        URL url = null;
        HttpURLConnection httpUrl = null;
        InputStream is = null;
        ByteArrayOutputStream outStream = null;
        try {
            fileUrl = fileUrl.replace("*", ":").replace("\\", "/");
            if (fileUrl.contains("localhost")) {
                fileUrl = fileUrl.substring(fileUrl.indexOf("upload"));
                File file = new File(FileUtil.getLocalFullPath((String)fileUrl));
                is = new FileInputStream(file);
            } else {
                url = new URL(fileUrl);
                httpUrl = (HttpURLConnection)url.openConnection();
                httpUrl.connect();
                is = httpUrl.getInputStream();
            }
            outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = is.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            rs = isB64Code ? Base64Utils.encodeToString((byte[])outStream.toByteArray()) : new String(outStream.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            this.log.error("upgradeFirmware error", (Throwable)e);
            throw new ZKBusinessException("upgradeFirmware error");
        }
        finally {
            try {
                if (Objects.nonNull(is)) {
                    is.close();
                }
                if (Objects.nonNull(outStream)) {
                    outStream.close();
                }
                if (Objects.nonNull(httpUrl)) {
                    httpUrl.disconnect();
                }
            }
            catch (IOException e) {
                this.log.error("upgradeFirmware error", (Throwable)e);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registry(String devSn, String regContent, int serverPort, String sessionId) {
        this.admsCacheManager.setDevModuleType(devSn, "acc");
        String retInfo = "";
        boolean allowConcurrentReg = this.admsDeviceService.allowConcurrentReg(devSn);
        if (!allowConcurrentReg) {
            this.log.warn("device concurrent reg over limit " + this.admsDeviceService.getMaxConcurrentRegCount() + ", reject sn=" + devSn);
            retInfo = "406";
            return retInfo;
        }
        this.log.info("acc device registry info\uff1a" + regContent);
        try {
            AdmsAuthDeviceItem authInfo = this.admsAuthDeviceService.getAuthDeviceInfo(devSn);
            if (authInfo != null && authInfo.getAuthFlag() != null && authInfo.getAuthFlag().booleanValue()) {
                retInfo = "RegistryCode=" + this.admsDeviceService.regAccDevice(devSn, sessionId, serverPort, regContent);
            } else {
                this.log.info("acc device sn=" + devSn + " no auth ,request reject");
                Map<String, String> optionsMap = DeviceDataUtil.formateStrToMap(regContent, ",");
                String gateway = optionsMap.get("GATEIPAddress");
                String ipAddress = optionsMap.get("IPAddress");
                if (!(authInfo != null && (gateway + ipAddress).equals(authInfo.getGateway() + authInfo.getIp()) && "2".equals(authInfo.getModeType()) && "acc".equals(authInfo.getDeviceType()))) {
                    String netMask = optionsMap.get("NetMask");
                    String mac = optionsMap.get("MAC");
                    String deviceType = optionsMap.get("DeviceType");
                    String deviceName = optionsMap.get("~DeviceName");
                    String server = optionsMap.get("WebServerURL");
                    AdmsAuthDeviceItem item = new AdmsAuthDeviceItem(ipAddress, mac, netMask, gateway, devSn, deviceType, server, deviceName);
                    item.setExParam(DeviceDataUtil.getExParamByOptionMap(optionsMap));
                    item.setProtype("push");
                    item.setModeType("2");
                    this.admsAuthDeviceService.setAuthDeviceInfo(item);
                }
                retInfo = "406";
            }
        }
        catch (Exception e) {
            retInfo = "Result=false, Message=Unknown Device";
            this.log.error("reg device error sn=" + devSn, (Throwable)e);
        }
        finally {
            this.admsDeviceService.regFinish(devSn);
        }
        return retInfo;
    }

    public String push(String sn) {
        String retInfo = "ServerVersion=%s\nServerName=%s\nPushVersion=%s\nErrorDelay=%s\nRequestDelay=%s\nTransTimes=%s\nTransInterval=%s\nTransTables=%s\nRealtime=%s\nSessionID=%s\nTimeoutSec=%s\n";
        try {
            String devJson = this.admsCacheManager.getDeviceInfo(sn);
            if (StringUtils.isNotBlank((CharSequence)devJson)) {
                JSONObject json = new JSONObject(devJson);
                retInfo = String.format(retInfo, JSONObjectUtil.getValueByKey(json, "ServerVersion"), JSONObjectUtil.getValueByKey(json, "ServerName"), JSONObjectUtil.getValueByKey(json, "PushVersion"), JSONObjectUtil.getValueByKey(json, "ErrorDelay"), JSONObjectUtil.getValueByKey(json, "RequestDelay"), JSONObjectUtil.getValueByKey(json, "TransTimes"), JSONObjectUtil.getValueByKey(json, "TransInterval"), JSONObjectUtil.getValueByKey(json, "TransTables"), JSONObjectUtil.getValueByKey(json, "Realtime"), JSONObjectUtil.getValueByKey(json, "SessionID"), JSONObjectUtil.getValueByKey(json, "TimeoutSec"));
                if (JSONObjectUtil.getValueByKey(json, "MultiBioDataSupport") != null) {
                    retInfo = retInfo + "MultiBioDataSupport=" + JSONObjectUtil.getValueByKey(json, "MultiBioDataSupport") + "\n";
                }
                if (JSONObjectUtil.getValueByKey(json, "MultiBioPhotoSupport") != null) {
                    retInfo = retInfo + "MultiBioPhotoSupport=" + JSONObjectUtil.getValueByKey(json, "MultiBioPhotoSupport") + "\n";
                }
            } else {
                retInfo = "406";
            }
        }
        catch (Exception e) {
            this.log.error("push  error", (Throwable)e);
            retInfo = "406";
        }
        return retInfo;
    }

    public String cdata(String sn, String uri, String data, int port, String sessionId) {
        String rs = "OK";
        String table = RequestUtil.getParams(uri, "table");
        String tableName = RequestUtil.getParams(uri, "tablename");
        String authType = RequestUtil.getParams(uri, "AuthType");
        String count = RequestUtil.getParams(uri, "count");
        String options = RequestUtil.getParams(uri, "options");
        String type = RequestUtil.getParams(uri, "type");
        String devJsonInfo = this.admsCacheManager.getDeviceInfo(sn);
        if (StringUtils.isBlank((CharSequence)devJsonInfo)) {
            return "406";
        }
        if (table == null && authType != null) {
            table = "AuthType";
        } else if (table == null && "BioData".equals(type)) {
            table = type;
        } else if ("tabledata".equals(table) && "errorlog".equals(tableName)) {
            table = tableName;
        }
        table = table != null ? table : "ask";
        this.printLog("cdata", data);
        switch (table) {
            case "rtlog": {
                rs = this.rtlog(sn, data);
                break;
            }
            case "rtstate": {
                rs = this.rtstate(sn, data);
                break;
            }
            case "options": {
                rs = this.dealOptions(sn, data);
                break;
            }
            case "tabledata": {
                rs = this.dealTableData(sn, data, table, count, tableName, type, port, sessionId);
                break;
            }
            case "AuthType": {
                rs = this.dealVerifyEvent(sn, data);
                break;
            }
            case "ConnectState": {
                rs = this.dealConnectState(data);
                break;
            }
            case "testdata": {
                rs = this.dealTestData(data, sn);
                break;
            }
            case "testsignal": {
                rs = "OK";
                break;
            }
            case "ask": {
                rs = "OK";
                break;
            }
            case "BioData": {
                rs = this.dealBioData(sn, data);
                break;
            }
            case "errorlog": {
                rs = this.dealErrorLog(sn, data);
                break;
            }
            default: {
                rs = "406";
            }
        }
        return rs;
    }

    private String dealErrorLog(String sn, String data) {
        String retInfo = "OK";
        String[] dataArray = data.split("\r\n");
        HashSet<Long> cmdIds = new HashSet<Long>();
        HashMap<Long, String> remarkMap = new HashMap<Long, String>();
        for (String tempData : dataArray) {
            tempData = tempData.split(" ")[1];
            Map<String, String> dataMap = DeviceDataUtil.formateStrToMap(tempData, "\t");
            Long cmdId = Long.parseLong(dataMap.get("cmdid"));
            cmdIds.add(cmdId);
            byte[] decode = Base64Util.decode((String)dataMap.get("additional"));
            JSONObject additional = JSONObjectUtil.createJson(new String(decode));
            String remark = "errcode:" + dataMap.get("errcode") + ",errmsg:" + dataMap.get("errmsg") + ",additional:" + additional + ";";
            if (remarkMap.containsKey(cmdId)) {
                remarkMap.put(cmdId, (String)remarkMap.get(cmdId) + remark);
                continue;
            }
            remarkMap.put(cmdId, remark);
        }
        Map admsDevCmdItems = this.admsDevCmdService.getItemListByCmdIds(cmdIds);
        if (admsDevCmdItems != null && admsDevCmdItems.size() > 0) {
            for (Map.Entry entry : admsDevCmdItems.entrySet()) {
                AdmsDevCmdItem admsDevCmdItem;
                admsDevCmdItem.setRemark(StringUtils.isNotBlank((CharSequence)(admsDevCmdItem = (AdmsDevCmdItem)entry.getValue()).getRemark()) ? admsDevCmdItem.getRemark() : "" + (String)remarkMap.get(entry.getKey()));
                this.admsDevCmdService.saveItem(admsDevCmdItem);
            }
        }
        return retInfo;
    }

    private String dealTestData(String data, String sn) {
        Map<String, String> map = DeviceDataUtil.formateStrToMap(data, "\t");
        String tempSn = sn;
        if (map.containsKey("sn")) {
            tempSn = map.get("sn");
        }
        this.admsCacheManager.cacheWGTestData(data, tempSn);
        return "OK";
    }

    private String dealConnectState(String data) {
        String[] stateArray;
        String retInfo = "OK";
        for (String state : stateArray = data.trim().split("\r\n")) {
            Map<String, String> map = DeviceDataUtil.formateStrToMap(state, "\t");
            this.admsDeviceService.updateAccChildDevConnState(Integer.parseInt(map.get("DevState")), map.get("SN"), "GET_RT_LOG");
        }
        return retInfo;
    }

    private String dealTableData(String sn, String data, String table, String count, String tableName, String type, int port, String sessionId) {
        String rs = "OK";
        try {
            this.admsDeviceService.updateDevOperateState(sn, "DATA UPDATE", "0");
            int actualCount = StringUtils.isBlank((CharSequence)data) ? 0 : data.split("\r\n").length;
            rs = tableName + "=" + actualCount;
            if (actualCount == Integer.parseInt(count)) {
                if ("registry".equals(type)) {
                    this.admsDeviceService.analysDeviceAuthorize(null, tableName, data, sn, port, sessionId);
                } else if ("identitycard".equals(tableName) && this.adms4AccService != null) {
                    this.adms4AccService.sendIDCardInfo(sn, table, tableName, count, data);
                } else {
                    boolean retValue = this.admsCacheManager.cacheUploadData(sn, table, tableName, count, data);
                    if (!retValue) {
                        rs = tableName + "=0";
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error("Exception  error", (Throwable)e);
            rs = "406";
        }
        return rs;
    }

    private String dealRTData(JSONObject admsDevice, String type) throws Exception {
        String rs = "OK";
        if ("time".equals(type)) {
            String retStr = "";
            Calendar cd = Calendar.getInstance();
            SimpleDateFormat gmtFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            gmtFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            String str = gmtFormat.format(cd.getTime());
            SimpleDateFormat generalFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = generalFormat.parse(str);
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("Z");
            rs = retStr = String.format("DateTime=%d,ServerTZ=%s", DeviceDataUtil.enCodeTime(date), sdf.format(cal.getTime()));
        }
        return rs;
    }

    private String dealVerifyEvent(String sn, String data) {
        String rs = "404";
        try {
            this.admsDeviceService.updateDevOperateState(sn, "AUTH_VALID", "0");
            rs = this.admsDeviceService.remoteVerify(sn, data);
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        return rs;
    }

    private String dealOptions(String sn, String data) {
        String rs = "OK";
        try {
            String[] optionKeyValues = data.split(",");
            HashMap<String, String> optionMap = new HashMap<String, String>();
            for (String okv : optionKeyValues) {
                String[] keyValue = okv.split("=");
                if (keyValue.length <= 1) continue;
                optionMap.put(keyValue[0], keyValue[1]);
            }
            optionMap.put("~SerialNumber", sn);
            this.admsDeviceService.updateAccDeviceOptions(sn, optionMap, "options", null);
        }
        catch (Exception e) {
            this.log.error("Exception  error", (Throwable)e);
            rs = "406";
        }
        return rs;
    }

    public String getRequest(String sn, String cookiesToken) {
        String retInfo = "OK";
        this.admsDeviceService.updateDevOperateState(sn, "GET_RT_LOG", "0");
        String cmd = "";
        JSONObject devInfo = JSONObjectUtil.createJson(this.admsCacheManager.getDeviceInfo(sn));
        cmd = devInfo != null && devInfo.has("CmdFormat") && "1".equals(JSONObjectUtil.getStrValueByKey(devInfo, "CmdFormat")) ? this.admsDeviceService.getChildDevCmd(sn) : this.admsDeviceService.getCmd(sn, 10);
        if (StringUtils.isNotBlank((CharSequence)cmd)) {
            retInfo = cmd;
        }
        return retInfo;
    }

    public String deviceCmd(String sn, String cookiesToken, String data) {
        this.printLog("cmd return", data);
        this.log.info("cmd return sn=" + sn + ",data=" + data);
        return this.admsDevCmdService.devReturnCmd(sn, data);
    }

    public String rtdata(String sn, String type) throws Exception {
        JSONObject admsDevice = JSONObjectUtil.createJson(this.admsCacheManager.getDeviceInfo(sn));
        return this.dealRTData(admsDevice, type);
    }

    public String querydata(String sn, String table, String count, int actualCount, String type, String data, String datafmt, String cmdId, String packcnt, String packidx, int port, String sessionId) {
        String retInfo = "OK";
        this.log.info("table=" + table + " actualCount=" + actualCount + "  count=" + Integer.parseInt(count) + "  packidx=" + Integer.parseInt(packidx) + "  packcnt=" + Integer.parseInt(packcnt));
        if ("tabledata".equals(type) || "vmtable".equals(type)) {
            retInfo = table + "=" + count;
            if (actualCount == Integer.parseInt(count)) {
                JSONObject queryJson = new JSONObject();
                JSONObjectUtil.setKeyValue(queryJson, "type", type);
                JSONObjectUtil.setKeyValue(queryJson, "table", table);
                JSONObjectUtil.setKeyValue(queryJson, "count", count);
                JSONObjectUtil.setKeyValue(queryJson, "cmdId", cmdId);
                JSONObjectUtil.setKeyValue(queryJson, "packcnt", packcnt);
                JSONObjectUtil.setKeyValue(queryJson, "packIdx", packidx);
                JSONObjectUtil.setKeyValue(queryJson, "data", data);
                JSONObjectUtil.setKeyValue(queryJson, "sn", sn);
                if (!this.admsDeviceService.cacheDevQueryData(sn, queryJson.toString())) {
                    retInfo = table + "=0";
                    this.log.info("cache query data sn=" + sn + ",table=" + table + " to Redis failed!");
                }
            }
        } else if ("options".equals(type) || "count".equals(type)) {
            if (!"".equals(data.trim())) {
                Map<String, String> devOptions = DeviceDataUtil.formateStrToMap(data.trim(), ",");
                this.admsDeviceService.updateAccDeviceOptions(sn, devOptions, type, cmdId);
            }
        } else if ("registry".equals(type)) {
            this.admsDeviceService.analysDeviceAuthorize(cmdId, table, data, sn, port, sessionId);
        }
        return retInfo;
    }

    public String rtlog(String sn, String data) {
        String retInfo = "OK";
        try {
            Map<String, String> dataMap = DeviceDataUtil.formateStrToMap(data, "\t");
            if (dataMap.containsKey("sn")) {
                sn = dataMap.get("sn");
            }
            this.admsCacheManager.cacheAccRtLog(sn, data);
        }
        catch (Exception e) {
            this.log.error("rtlog  error", (Throwable)e);
            retInfo = "406";
        }
        return retInfo;
    }

    public String rtstate(String sn, String data) {
        String[] dataArray;
        String retInfo = "OK";
        for (String devRTData : dataArray = data.split("\r\n")) {
            DeviceDoorState deviceDoorState;
            Map<String, String> dataMap = DeviceDataUtil.formateStrToMap(devRTData, "\t");
            String devStr = this.admsCacheManager.getDeviceInfo(sn);
            if (dataMap.containsKey("sn")) {
                String childDevStr = this.admsCacheManager.getDeviceInfo(dataMap.get("sn"));
                if (StringUtils.isBlank((CharSequence)childDevStr)) continue;
                devStr = childDevStr;
            }
            JSONObject devJson = JSONObjectUtil.createJson(devStr);
            int lockCount = JSONObjectUtil.getIntValueByKey(devJson, "LockCount");
            String deviceType = JSONObjectUtil.getStrValueByKey(devJson, "DeviceType");
            String machineType = JSONObjectUtil.getStrValueByKey(devJson, "MachineType");
            if (lockCount > 0) {
                deviceDoorState = new DeviceDoorState();
                deviceDoorState.setSn(dataMap.containsKey("sn") ? dataMap.get("sn") : sn);
                deviceDoorState.setSensor(DeviceDataUtil.getNewBinary(dataMap.get("sensor"), lockCount, 2, false, deviceType));
                deviceDoorState.setRelay(dataMap.containsKey("relay") ? DeviceDataUtil.getNewBinary(dataMap.get("relay"), lockCount, 1, false, deviceType) : null);
                deviceDoorState.setConnect(String.valueOf(1));
                deviceDoorState.setDoor(dataMap.containsKey("door") ? DeviceDataUtil.getNewBinary(dataMap.get("door"), lockCount, 8, true, deviceType) : null);
                deviceDoorState.setAlarm(dataMap.containsKey("alarm") ? DeviceDataUtil.getNewBinary(dataMap.get("alarm"), lockCount, 8, true, deviceType) : null);
                this.admsDeviceService.updateAccDeviceDoorStates(deviceDoorState.getSn(), deviceDoorState);
                continue;
            }
            if (!"40".equals(machineType)) continue;
            deviceDoorState = new DeviceDoorState();
            deviceDoorState.setSn(dataMap.containsKey("sn") ? dataMap.get("sn") : sn);
            deviceDoorState.setSensor("");
            deviceDoorState.setRelay("");
            deviceDoorState.setConnect(String.valueOf(1));
            deviceDoorState.setDoor("");
            deviceDoorState.setAlarm("");
            this.admsDeviceService.updateAccDeviceDoorStates(deviceDoorState.getSn(), deviceDoorState);
        }
        return retInfo;
    }

    public String heartbeat(String sn, String data, String cookiesToken) {
        this.admsDeviceService.updateDevOperateState(sn, "DEV_HEARTBEAT", "0");
        return "OK";
    }

    private String dealBioData(String sn, String data) {
        String retInfo = "OK";
        String[] dataArray = data.split("\t");
        JSONObject dataJson = new JSONObject();
        for (String bioData : dataArray) {
            if (!"PIN".equals(bioData.split("=")[0])) continue;
            JSONObjectUtil.setKeyValue(dataJson, bioData.split("=")[0], bioData.split("=")[1]);
        }
        JSONObjectUtil.setKeyValue(dataJson, "sn", sn);
        JSONObjectUtil.setKeyValue(dataJson, "data", data);
        this.admsDeviceService.sendAutoBioData(dataJson.toString());
        return retInfo;
    }
}

