/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.push.http;

import com.zkteco.zkbiosecurity.adms.distributor.push.http.HttpServerHandler;
import com.zkteco.zkbiosecurity.adms.distributor.push.processor.PushProcessor;
import com.zkteco.zkbiosecurity.base.config.SSLConfig;
import com.zkteco.zkbiosecurity.core.utils.ResourceUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class HttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private String ishttps;
    private PushProcessor pushProcessor;

    public HttpServerInitializer() {
    }

    public HttpServerInitializer(PushProcessor pushProcessor, String ishttps) {
        this.pushProcessor = pushProcessor;
        this.ishttps = ishttps;
    }

    public void initChannel(SocketChannel socketChannel) throws Exception {
        ChannelPipeline pipeline = socketChannel.pipeline();
        if ("true".equals(this.ishttps)) {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            KeyStore ks = KeyStore.getInstance(SSLConfig.serverSslKeyStoreType);
            String keyStorePassword = SSLConfig.serverSslKeyStorePassword;
            ks.load(ResourceUtil.getResource((String)("file:" + SSLConfig.serverSslKeystore)).getInputStream(), keyStorePassword.toCharArray());
            String keyPassword = SSLConfig.serverSslKeyStorePassword;
            kmf.init(ks, keyPassword.toCharArray());
            sslcontext.init(kmf.getKeyManagers(), null, null);
            SSLEngine sslEngine = sslcontext.createSSLEngine();
            sslEngine.setUseClientMode(false);
            sslEngine.setNeedClientAuth(false);
            pipeline.addLast(new ChannelHandler[]{new SslHandler(sslEngine)});
        }
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(0x3200000));
        pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(60));
        pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
        pipeline.addLast("chunked", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("handler", (ChannelHandler)new HttpServerHandler(this.pushProcessor));
    }
}

