/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.cache;

import com.zkteco.zkbiosecurity.adms.distributor.utils.JSONObjectUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class AdmsCacheManager {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    String ADMS_DEVICE_MODULE = "adms:device:module:";
    String ADMS_COCURRENT_REG_COUNT = "adms:cocurrentRegCount";
    String ADMS_DEVICE_INFO = "adms:devInfo:";
    String ADMS_CMD_ID = "ADMS_CMD_ID:";
    String ADMS_AUTH_DEVICE = "cache:adms:authDevice:";
    int TOP_10 = 10;
    int HEART_EXPIRE_TIME = 60;
    String ADMS_AUTH_IP_LIST = "adms:device:authIpList";

    public String getDevModuleType(String sn) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)(this.ADMS_DEVICE_MODULE + sn));
    }

    public String setDevModuleType(String sn, String moduleType) {
        this.stringRedisTemplate.opsForValue().set((Object)(this.ADMS_DEVICE_MODULE + sn), (Object)moduleType);
        return moduleType;
    }

    public long concurrentRegCount() {
        return this.stringRedisTemplate.keys((Object)(this.ADMS_COCURRENT_REG_COUNT + ":*")).size();
    }

    public void setAllowRegDevice(String sn) {
        this.stringRedisTemplate.opsForValue().set((Object)(this.ADMS_COCURRENT_REG_COUNT + ":" + sn), (Object)sn);
        this.stringRedisTemplate.expire((Object)(this.ADMS_COCURRENT_REG_COUNT + ":" + sn), (long)RandomUtils.nextInt((int)5, (int)12), TimeUnit.SECONDS);
    }

    public void removeConcurrentReg(String sn) {
    }

    public boolean exsitRegDev(String sn) {
        return this.stringRedisTemplate.hasKey((Object)(this.ADMS_COCURRENT_REG_COUNT + ":" + sn));
    }

    public void cacheDeviceInfo(String sn, String devJson) {
        this.stringRedisTemplate.opsForValue().set((Object)(this.ADMS_DEVICE_INFO + sn), (Object)devJson);
    }

    public String getDeviceInfo(String sn) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)(this.ADMS_DEVICE_INFO + sn));
    }

    public void putCommCmdCache(String sn, String cmdContent) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("ADMS_COMMON_CMD:" + sn), (Object)cmdContent);
    }

    public void putImmeCmdCache(String sn, Long cmdId, String cmdContent, Long timeout) {
        this.stringRedisTemplate.opsForValue().set((Object)(this.ADMS_CMD_ID + cmdId), (Object)cmdContent);
        long time = 30L;
        if (timeout != null) {
            time = timeout;
        }
        this.stringRedisTemplate.expire((Object)(this.ADMS_CMD_ID + cmdId), time, TimeUnit.SECONDS);
        this.stringRedisTemplate.opsForList().rightPush((Object)("ADMS_IMME_CMD:" + sn), (Object)(cmdId + ""));
    }

    public List<String> getImmeCmdIds(String sn) {
        return this.stringRedisTemplate.boundListOps((Object)("ADMS_IMME_CMD:" + sn)).range(0L, -1L);
    }

    public List<String> getTopNImmeCmdIds(String sn, int cmdCount) {
        return this.stringRedisTemplate.boundListOps((Object)("ADMS_IMME_CMD:" + sn)).range(0L, (long)(cmdCount - 1));
    }

    public List<String> getTop10CommCmd(String sn) {
        return this.stringRedisTemplate.opsForList().range((Object)("ADMS_COMMON_CMD:" + sn), 0L, (long)(this.TOP_10 - 1));
    }

    public List<String> getTopNCommCmd(String sn, int cmdCount) {
        return this.stringRedisTemplate.opsForList().range((Object)("ADMS_COMMON_CMD:" + sn), 0L, (long)(cmdCount - 1));
    }

    public void removeImmeListId(String sn, String cmdId) {
        this.stringRedisTemplate.opsForList().leftPop((Object)("ADMS_IMME_CMD:" + sn));
    }

    public String getImmeCmdById(String cmdId) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)(this.ADMS_CMD_ID + cmdId));
    }

    public void removeImmeCmdId(String cmdId) {
        this.stringRedisTemplate.delete((Object)(this.ADMS_CMD_ID + cmdId));
    }

    public void removeCommCmd(String sn, String cmd) {
        this.stringRedisTemplate.opsForList().remove((Object)("ADMS_COMMON_CMD:" + sn), 1L, (Object)cmd);
    }

    public void updateDevHeartbeat(String sn) {
        this.stringRedisTemplate.opsForValue().set((Object)("adms:heartbeat:" + sn), (Object)(System.currentTimeMillis() + ""));
        this.stringRedisTemplate.expire((Object)("adms:heartbeat:" + sn), (long)this.HEART_EXPIRE_TIME, TimeUnit.SECONDS);
    }

    public String getOnlineStatus(String sn) {
        if (this.stringRedisTemplate.hasKey((Object)("adms:heartbeat:" + sn)).booleanValue()) {
            return "1";
        }
        return "0";
    }

    public boolean isOnline(String sn) {
        return this.getOnlineStatus(sn).equals("1");
    }

    public void removeDeviceBySn(String sn) {
        this.setDeviceDeleting(sn);
        this.stringRedisTemplate.delete((Object)(this.ADMS_DEVICE_INFO + sn));
        this.stringRedisTemplate.delete((Object)("ADMS_COMMON_CMD:" + sn));
        this.stringRedisTemplate.delete((Object)("ADMS_IMME_CMD:" + sn));
        this.stringRedisTemplate.delete((Object)("adms:dev:operate:state:" + sn));
        this.stringRedisTemplate.delete((Object)("adms:accRtState:" + sn));
        this.stringRedisTemplate.delete((Object)("adms:psgRtState:" + sn));
        this.stringRedisTemplate.delete((Object)(this.ADMS_DEVICE_MODULE + sn));
        this.stringRedisTemplate.delete((Object)(this.ADMS_AUTH_DEVICE + sn));
    }

    public void setDeviceDeleting(String sn) {
        this.stringRedisTemplate.opsForValue().set((Object)("adms:deleting:" + sn), (Object)(System.currentTimeMillis() + ""));
        this.stringRedisTemplate.expire((Object)("adms:deleting:" + sn), 10L, TimeUnit.SECONDS);
    }

    public boolean doDeleting(String sn) {
        return this.stringRedisTemplate.hasKey((Object)("adms:deleting:" + sn));
    }

    public Long getDevCmdCount(String sn) {
        long commCount = this.stringRedisTemplate.boundListOps((Object)("ADMS_COMMON_CMD:" + sn)).size();
        long immeCount = this.stringRedisTemplate.boundListOps((Object)("ADMS_IMME_CMD:" + sn)).size();
        return commCount + immeCount;
    }

    public void setDevRunState(String sn, String devOperateStateStr) {
        this.stringRedisTemplate.opsForValue().set((Object)("adms:dev:operate:state:" + sn), (Object)devOperateStateStr);
    }

    public String getDevRunState(String sn) {
        String jsonStr = (String)this.stringRedisTemplate.opsForValue().get((Object)("adms:dev:operate:state:" + sn));
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return "";
        }
        JSONObject jsonObj = JSONObjectUtil.createJson(jsonStr);
        JSONObjectUtil.setKeyValue(jsonObj, "cmdCount", this.getDevCmdCount(sn));
        return jsonObj.toString();
    }

    public void cacheAccRtLog(String sn, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:accLog:" + sn), (Object)data);
    }

    public void cacheAccRtState(String sn, String data) {
        this.stringRedisTemplate.opsForValue().set((Object)("adms:accRtState:" + sn), (Object)data);
    }

    public String getAccRtState(String sn) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)("adms:accRtState:" + sn));
    }

    public void cacheEleRtLog(String sn, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:eleLog:" + sn), (Object)data);
    }

    public void cacheEleRtState(String sn, String data) {
        this.stringRedisTemplate.opsForValue().set((Object)("adms:eleRtState:" + sn), (Object)data);
    }

    public void cachePosLog(String sn, String table, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:posLog:" + table + ":" + sn), (Object)data);
    }

    public void cacheAttLog(String sn, String table, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:att:" + table + ":" + sn), (Object)data);
    }

    public void cacheInsLog(String sn, String table, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:ins:" + table + ":" + sn), (Object)data);
    }

    public void cacheAttPhoto(String sn, String attphoto, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:att:" + attphoto + ":" + sn), (Object)data);
    }

    public void cacheInsPhoto(String sn, String attphoto, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:ins:" + attphoto + ":" + sn), (Object)data);
    }

    public void cacheAttOperLog(String sn, String operlog, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:att:" + operlog + ":" + sn), (Object)data);
    }

    public void cacheInsOperLog(String sn, String operlog, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:ins:" + operlog + ":" + sn), (Object)data);
    }

    public void cacheAttBioData(String sn, String biodata, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:att:" + biodata + ":" + sn), (Object)data);
    }

    public void cacheInsBioData(String sn, String biodata, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:ins:" + biodata + ":" + sn), (Object)data);
    }

    public void cachePidLog(String sn, String table, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:pid:" + table + ":" + sn), (Object)data);
    }

    public void cachePidPhoto(String sn, String pidphoto, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:pid:" + pidphoto + ":" + sn), (Object)data);
    }

    public void cachePidOperLog(String sn, String operlog, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:pid:" + operlog + ":" + sn), (Object)data);
    }

    public void cachePidIdCard(String sn, String idCard, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:pid:" + idCard + ":" + sn), (Object)data);
    }

    public void cachePidBioData(String sn, String biodata, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:pid:" + biodata + ":" + sn), (Object)data);
    }

    public boolean cachePsgUploadData(String sn, String table, String tableName, String count, String data) {
        JSONObject jsonData = new JSONObject();
        JSONObjectUtil.setKeyValue(jsonData, "type", table);
        JSONObjectUtil.setKeyValue(jsonData, "table", tableName);
        JSONObjectUtil.setKeyValue(jsonData, "count", count);
        JSONObjectUtil.setKeyValue(jsonData, "data", data);
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:psgUploadData:" + sn), (Object)jsonData.toString());
        return true;
    }

    public void cachePsgQueryData(String sn, String jsonData) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:psgDevice:query:" + sn), (Object)jsonData);
    }

    public void cachePsgRtLog(String sn, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:psgLog:" + sn), (Object)data);
    }

    public void cachePsgRtState(String sn, String data) {
        this.stringRedisTemplate.opsForValue().set((Object)("adms:psgRtState:" + sn), (Object)data);
    }

    public String getPsgRtState(String sn) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)("adms:psgRtState:" + sn));
    }

    public void disableDevInfo(String sn) {
        String devJson = this.getDeviceInfo(sn);
        JSONObject json = JSONObjectUtil.createJson(devJson);
        JSONObjectUtil.setKeyValue(json, "enabled", false);
        this.cacheDeviceInfo(sn, json.toString());
    }

    public void enableDevInfo(String sn) {
        String devJson = this.getDeviceInfo(sn);
        JSONObject json = JSONObjectUtil.createJson(devJson);
        JSONObjectUtil.setKeyValue(json, "enabled", true);
        this.cacheDeviceInfo(sn, json.toString());
    }

    public void clearCmdCache(String sn) {
        this.stringRedisTemplate.delete((Object)("ADMS_COMMON_CMD:" + sn));
        this.stringRedisTemplate.delete((Object)("ADMS_IMME_CMD:" + sn));
    }

    public boolean cacheUploadData(String sn, String table, String tableName, String count, String data) {
        JSONObject jsonData = new JSONObject();
        JSONObjectUtil.setKeyValue(jsonData, "type", table);
        JSONObjectUtil.setKeyValue(jsonData, "table", tableName);
        JSONObjectUtil.setKeyValue(jsonData, "count", count);
        JSONObjectUtil.setKeyValue(jsonData, "data", data);
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:uploadData:" + sn), (Object)jsonData.toString());
        return true;
    }

    public boolean cacheAiUploadData(String sn, String table, String tableName, String count, String data) {
        JSONObject jsonData = new JSONObject();
        JSONObjectUtil.setKeyValue(jsonData, "type", table);
        JSONObjectUtil.setKeyValue(jsonData, "table", tableName);
        JSONObjectUtil.setKeyValue(jsonData, "count", count);
        JSONObjectUtil.setKeyValue(jsonData, "data", data);
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:aiUploadData:" + sn), (Object)jsonData.toString());
        return true;
    }

    public void setDevEncoding(String sn, String encoding) {
        this.stringRedisTemplate.opsForValue().set((Object)("adms:device:encoding:" + sn), (Object)encoding);
    }

    public String getDevEncoding(String sn) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)("adms:device:encoding:" + sn));
    }

    public void cacheQueryData(String sn, String jsonData) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:device:query:" + sn), (Object)jsonData);
    }

    public void cacheEleQueryData(String sn, String jsonData) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:eledevice:query:" + sn), (Object)jsonData);
    }

    public void setAccChildDevHeartbeat(String sn) {
        if (this.stringRedisTemplate.hasKey((Object)("adms:heartbeat:" + sn)).booleanValue()) {
            this.delAccChildDevHeartbeat(sn);
        }
        this.stringRedisTemplate.opsForValue().set((Object)("adms:heartbeat:" + sn), (Object)(System.currentTimeMillis() + ""));
    }

    public void delAccChildDevHeartbeat(String sn) {
        this.stringRedisTemplate.delete((Object)("adms:heartbeat:" + sn));
    }

    public void cacheWGTestData(String data, String sn) {
        JSONObject dataJson = new JSONObject();
        JSONObjectUtil.setKeyValue(dataJson, "data", data);
        JSONObjectUtil.setKeyValue(dataJson, "sn", sn);
        this.stringRedisTemplate.opsForValue().set((Object)("adms:WGTestData:" + sn), (Object)dataJson.toString());
        this.stringRedisTemplate.expire((Object)("adms:WGTestData:" + sn), 60L, TimeUnit.SECONDS);
    }

    public boolean hasDeviceInfo(String sn) {
        return this.stringRedisTemplate.hasKey((Object)(this.ADMS_DEVICE_INFO + sn));
    }

    public boolean getDevEnabledState(String sn) {
        String devJson = this.getDeviceInfo(sn);
        return !StringUtils.isNotBlank((CharSequence)devJson) || JSONObjectUtil.getBooleanValueByKey(devJson, "enabled") != false;
    }

    public void cacheCmdReuslt(String sn, Long cmdId, Integer result) {
        this.stringRedisTemplate.opsForValue().set((Object)("adms:cmd:return:" + cmdId), (Object)(result + ""), 10L, TimeUnit.DAYS);
    }

    public void cacheCmdReusltAndRemark(String sn, Long cmdId, Integer result, String remark) {
        this.stringRedisTemplate.opsForValue().set((Object)("adms:cmd:return:" + cmdId), (Object)(result + "_" + remark), 10L, TimeUnit.DAYS);
    }

    public Set<String> loadCmdReuslt() {
        return this.stringRedisTemplate.keys((Object)"adms:cmd:return:*");
    }

    public String getCmdReturnVal(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public void removeCmdReturnKey(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    public boolean hasRs485Device(Short comPort) {
        return this.stringRedisTemplate.hasKey((Object)("adms:pull:RS485_COM_" + comPort));
    }

    public Set<String> getRs485Device(String key) {
        return this.stringRedisTemplate.boundSetOps((Object)key).members();
    }

    public void setRs485Device(Short comPort, String deviceSn) {
        this.stringRedisTemplate.boundSetOps((Object)("adms:pull:RS485_COM_" + comPort)).add((Object[])new String[]{deviceSn});
    }

    public void delRs485Device(Short comPort) {
        this.stringRedisTemplate.boundSetOps((Object)"adms:pull:RS485_COM_").remove(new Object[]{comPort});
    }

    public void delRs485Device(String key, String sn) {
        this.stringRedisTemplate.boundSetOps((Object)key).remove(new Object[]{sn});
    }

    public void delAllRs485Device() {
        Set keys = this.stringRedisTemplate.keys((Object)"adms:pull:RS485_COM_*");
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                this.stringRedisTemplate.delete((Object)key);
            }
        }
    }

    public Set<String> getAllRs485CacheKeySet() {
        return this.stringRedisTemplate.keys((Object)"adms:pull:RS485_COM_*");
    }

    public String getCacheValueByKey(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
    }

    public void delete(String transKey) {
        this.stringRedisTemplate.delete((Object)transKey);
    }

    public void set(String transKey, String transValue) {
        this.stringRedisTemplate.opsForValue().set((Object)transKey, (Object)transValue);
    }

    public void cachePsgRtIrState(String sn, String data) {
        this.stringRedisTemplate.opsForValue().set((Object)("adms:psgIrState:" + sn), (Object)data);
    }

    public String getPsgRtIrState(String sn) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)("adms:psgIrState:" + sn));
    }

    public void cacheOpLog(String sn, String table, String data) {
        this.stringRedisTemplate.opsForList().rightPush((Object)("adms:att:" + table + ":" + sn), (Object)data);
    }

    public void addAuthIpList(String ipAddress) {
        this.stringRedisTemplate.opsForSet().add((Object)this.ADMS_AUTH_IP_LIST, (Object[])new String[]{ipAddress});
    }

    public boolean isAuthIp(String ipAddress) {
        return this.stringRedisTemplate.opsForSet().isMember((Object)this.ADMS_AUTH_IP_LIST, (Object)ipAddress);
    }

    public void delAuthIp(String ipAddress) {
        this.stringRedisTemplate.opsForSet().remove((Object)this.ADMS_AUTH_IP_LIST, new Object[]{ipAddress});
    }
}

