/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ins.remote.InsTransactionRemote;
import com.zkteco.zkbiosecurity.ins.service.InsTransactionService;
import com.zkteco.zkbiosecurity.ins.vo.InsTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsTransactionController
extends ExportController
implements InsTransactionRemote {
    @Autowired
    private InsTransactionService insTransactionService;

    @RequiresPermissions(value={"ins:transaction"})
    public ModelAndView index() {
        return new ModelAndView("ins/transaction/insTransaction");
    }

    @RequiresPermissions(value={"ins:transaction:refresh"})
    public DxGrid list(InsTransactionItem condition) {
        Pager pager = this.insTransactionService.loadPagerByAuthUserFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ins:transaction:export"})
    @LogRequest(module="ins_module", object="ins_transaction_manager", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String exportType = request.getParameter("exportType");
        String recordStart = request.getParameter("recordstart");
        String recordCount = request.getParameter("recordcount");
        InsTransactionItem insTransactionItem = new InsTransactionItem();
        this.setConditionValue((BaseItem)insTransactionItem);
        int beginIndex = 0;
        int endIndex = 30000;
        if (exportType.equals("3") && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            beginIndex = Integer.valueOf(recordStart);
            beginIndex = beginIndex > 0 ? beginIndex - 1 : 0;
            int maxCount = Integer.valueOf(recordCount) > 30000 ? 30000 : Integer.valueOf(recordCount);
            endIndex = beginIndex + maxCount - 1;
        }
        List intemList = this.insTransactionService.getItemData(request.getSession().getId(), InsTransactionItem.class, insTransactionItem, beginIndex, endIndex);
        this.excelExport(intemList, InsTransactionItem.class);
    }

    public ZKResultMsg getPhoto(String pin, String sn, String attDate) {
        ZKResultMsg res = new ZKResultMsg();
        String photoDate = attDate.replaceAll("-", "").replaceAll(" ", "").replaceAll(":", "");
        String photoName = photoDate + "-" + pin + ".jpg";
        String src = "/upload/ins/transactionPhoto/" + sn + '/' + attDate.split(" ")[0] + '/' + photoName;
        res.setData((Object)src);
        return res;
    }
}

