/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.ins.remote.InsAreaPersonByAreaRemote;
import com.zkteco.zkbiosecurity.ins.service.InsAreaPersonByAreaService;
import com.zkteco.zkbiosecurity.ins.vo.InsAreaPersonByAreaItem;
import com.zkteco.zkbiosecurity.ins.vo.InsAreaSelectPersonItem;
import com.zkteco.zkbiosecurity.ins.vo.InsPersonInAreaItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsAreaPersonByAreaController
extends BaseController
implements InsAreaPersonByAreaRemote {
    @Autowired
    private InsAreaPersonByAreaService insAreaPersonByAreaService;
    @Autowired
    private ProgressCache progressCache;
    private Logger logger = LoggerFactory.getLogger(InsAreaPersonByAreaController.class);

    @RequiresPermissions(value={"ins:areaPersonByArea"})
    public ModelAndView index() {
        return new ModelAndView("ins/areaPersonByArea/insAreaPersonByArea");
    }

    @RequiresPermissions(value={"ins:areaPersonByArea:refresh"})
    public DxGrid list(InsAreaPersonByAreaItem condition) {
        Pager pager = this.insAreaPersonByAreaService.loadPagerByAuthAreaFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ins:areaPersonByArea:refresh"})
    public DxGrid getAreaPersonList(InsPersonInAreaItem condition) {
        condition.setType("INS_AREA");
        Pager pager = this.insAreaPersonByAreaService.getPersonItemList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectPersonlist(InsAreaSelectPersonItem codition) {
        Pager pager = new Pager();
        if (codition.getType().equals("noSelected")) {
            pager = this.insAreaPersonByAreaService.getNoExistPerson(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        } else if (codition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg getPersonCountByDept(@RequestParam(value="deptIds", required=false) String deptIds) {
        long personCount = this.insAreaPersonByAreaService.getPersonCountByDept(deptIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)personCount));
    }

    @RequiresPermissions(value={"ins:areaPersonByArea:addPerson"})
    @LogRequest(module="ins_module", object="common_setByArea", opType="common_op_addPerson", requestParams={"areaName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg addPerson(@RequestParam(value="areaId") String areaId, @RequestParam(value="personIds") String personIds, @RequestParam(value="deptIds") String deptIds) {
        String clientId = this.request.getParameter("clientId");
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.insAreaPersonByAreaService.getPersonIdsByDeptIds(deptIds);
        }
        if (StringUtils.isNotBlank((CharSequence)personIds) && StringUtils.isNotBlank((CharSequence)areaId)) {
            try {
                List personArrayIds = this.insAreaPersonByAreaService.splitPersonIds(personIds, 200);
                int[] currentCount = new int[]{0};
                int[] totalCount = new int[]{personArrayIds.size()};
                personArrayIds.parallelStream().forEach(personArrayId -> {
                    this.insAreaPersonByAreaService.addPersonByAreaIds(personArrayId, areaId);
                    currentCount[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
            }
            catch (Exception e) {
                this.logger.error("addPerson with area error", (Throwable)e);
            }
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

