/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.init;

import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.service.PersWiegandFmtService;
import com.zkteco.zkbiosecurity.pers.vo.PersWiegandFmtItem;
import com.zkteco.zkbiosecurity.system.constants.BasePrintTemplateConstants;
import com.zkteco.zkbiosecurity.system.service.BasePrintParamService;
import com.zkteco.zkbiosecurity.system.service.BasePrintTemplateService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BasePrintParamItem;
import com.zkteco.zkbiosecurity.system.vo.BasePrintTemplateItem;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=20)
public class PersInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private PersWiegandFmtService persWiegandFmtService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BasePrintParamService basePrintParamService;
    @Autowired
    private BasePrintTemplateService basePrintTemplateService;
    @Value(value="${system.productCode}")
    private String productCode;
    @Value(value="${system.language:zh_CN}")
    private String language;
    @Value(value="${system.isCloud:false}")
    private Boolean isCloud;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("PersInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initPersWiegandFmtItem();
            this.initPersParams();
            if ("ZKBioSecurity".equals(this.productCode)) {
                this.initPrintTemplate();
            }
            if (!("zh_CN".equals(this.language) || this.isCloud.booleanValue() || "ZKBioAccess".equals(this.productCode))) {
                this.initAppMenus();
            }
            this.baseSysParamService.setAlreadyInitModule("PersInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("Pers", "pers_module", "pers", "system", "true", Integer.valueOf(2));
        systemItem = this.authPermissionService.initData(systemItem);
        AuthPermissionItem subMenuItem1 = new AuthPermissionItem("PersPersonManager", "pers_person_manager", "pers:person:manager", "menu", "true", Integer.valueOf(1));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("persPerson.do");
        subMenuItem1.setImg("pers.png");
        subMenuItem1.setImgHover("pers_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("PersPerson", "pers_person", "pers:person", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persPerson.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("PersPersonRefresh", "common_op_refresh", "pers:person:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonAdd", "common_op_new", "pers:person:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonEdit", "common_op_edit", "pers:person:edit", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if ("ZKBioSecurity".equals(this.productCode)) {
            subButtonItem = new AuthPermissionItem("PersPersonLeave", "pers_person_leave", "pers:person:leave", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subButtonItem = new AuthPermissionItem("PersPersonDeptChange", "pers_person_departmentChange", "pers:person:deptChange", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if ("ZKBioSecurity".equals(this.productCode)) {
            subButtonItem = new AuthPermissionItem("PersPersonPositionChange", "pers_position_change", "pers:person:batchPositionChange", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subButtonItem = new AuthPermissionItem("PersPersonDel", "common_op_del", "pers:person:del", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonExport", "pers_export_personInfo", "pers:person:export", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonImport", "pers_import_personInfo", "pers:person:import", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonDataCount", "pers_person_dataCount", "pers:person:dataCount", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if ("ZKBioSecurity".equals(this.productCode)) {
            subButtonItem = new AuthPermissionItem("PersPersonCardPrint", "pers_person_cardprint", "pers:person:cardPrint", "button", "true", Integer.valueOf(11));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subButtonItem = new AuthPermissionItem("PersPersonExportBioTemplate", "pers_export_personBioTemplate", "pers:bioTemplate:export", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonExportPhoto", "pers_export_personPhoto", "pers:person:exportPhoto", "button", "true", Integer.valueOf(13));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonImportBioTemplate", "pers_import_biologicalTemplate", "pers:bioTemplate:import", "button", "true", Integer.valueOf(14));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonImportPhoto", "pers_import_personPhoto", "pers:person:importPhoto", "button", "true", Integer.valueOf(15));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonExportTemplate", "pers_export_personInfoTemplate", "pers:person:exportTemplate", "button", "true", Integer.valueOf(16));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonDelBioTemplate", "pers_person_delBioTemplate", "pers:person:delBioTemplate", "button", "true", Integer.valueOf(17));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonImportLeavePerson", "pers_dimission_import", "pers:person:importLeavePerson", "button", "true", Integer.valueOf(18));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersPersonExportLeavePersonTemplate", "pers_dimission_downloadTemplate", "pers:person:exportLeavePersonTemplate", "button", "true", Integer.valueOf(19));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AuthDepartmentItem", "pers_department", "auth:department", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("authDepartment.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AuthDepartmentItemRefresh", "common_op_refresh", "auth:department:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthDepartmentItemAdd", "common_op_new", "auth:department:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthDepartmentItemEdit", "common_op_edit", "auth:department:edit", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthDepartmentItemDel", "common_op_del", "auth:department:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthDepartmentItemExport", "common_op_export", "auth:department:export", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthDepartmentItemImport", "common_op_import", "auth:department:import", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AuthDepartmentExportTemplate", "auth_dept_exportTemplate", "auth:department:exportTemplate", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if ("ZKBioSecurity".equals(this.productCode)) {
            subMenuItem = new AuthPermissionItem("PersPosition", "pers_position", "pers:position", "menu", "true", Integer.valueOf(3));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("persPosition.do");
            subMenuItem = this.authPermissionService.initData(subMenuItem);
            subButtonItem = new AuthPermissionItem("PersPositionRefresh", "common_op_refresh", "pers:position:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PersPositionAdd", "common_op_new", "pers:position:add", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PersPositionEdit", "common_op_edit", "pers:position:edit", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PersPositionDel", "common_op_del", "pers:position:del", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PersPositionExport", "common_op_export", "pers:position:export", "button", "true", Integer.valueOf(6));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PersPositionImport", "common_op_import", "pers:position:import", "button", "true", Integer.valueOf(7));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PersPositionExportTemplate", "pers_position_downloadTemplate", "pers:position:exportTemplate", "button", "true", Integer.valueOf(8));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subMenuItem = new AuthPermissionItem("PersLeave", "pers_leave", "pers:leavePerson", "menu", "true", Integer.valueOf(4));
            subMenuItem.setParentId(subMenuItem1.getId());
            subMenuItem.setActionLink("persLeavePerson.do");
            subMenuItem = this.authPermissionService.initData(subMenuItem);
            subButtonItem = new AuthPermissionItem("PersLeaveRefresh", "common_op_refresh", "pers:leavePerson:refresh", "button", "true", Integer.valueOf(1));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PersLeaveEdit", "common_op_edit", "pers:leavePerson:edit", "button", "true", Integer.valueOf(2));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PersLeaveReinstated", "pers_leavePerson_reinstated", "pers:leavePerson:reinstated", "button", "true", Integer.valueOf(3));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PersLeaveDel", "common_op_del", "pers:leavePerson:del", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("PersTempPerson", "pers_tempPerson", "pers:tempPerson", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persTempPerson.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersTempPersonRefresh", "common_op_refresh", "pers:tempPerson:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersTempPersonAudit", "pers_tempPerson_audit", "pers:tempPerson:audit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersTempPersonDel", "common_op_del", "pers:tempPerson:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersTempPersonView", "pers_tempPerson_view", "pers:tempPerson:view", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersAttribute", "pers_attribute", "pers:attribute", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persAttribute.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersAttributeRefresh", "common_op_refresh", "pers:attribute:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersAttributeAdd", "common_op_new", "pers:attribute:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersAttributeEdit", "common_op_edit", "pers:attribute:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersAttributeDel", "common_op_del", "pers:attribute:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersParams", "common_leftMenu_paramSet", "pers:params", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("skip.do?page=pers_params_params");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersParamsEdit", "common_op_edit", "pers:params:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PersCardManager", "pers_card_manager", "pers:card:manager", "menu", "true", Integer.valueOf(2));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("persCard.do");
        subMenuItem1.setImg("pers_card.png");
        subMenuItem1.setImgHover("pers_card_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PersCard", "pers_card", "pers:card", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persCard.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersCardRefresh", "common_op_refresh", "pers:card:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if ("ZKBioSecurity".equals(this.productCode)) {
            subButtonItem = new AuthPermissionItem("PersCardLoss", "pers_lossCard_entity", "pers:card:batchCardLoss", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
            subButtonItem = new AuthPermissionItem("PersCardRevert", "pers_revertCard_entity", "pers:card:batchCardRevert", "button", "true", Integer.valueOf(5));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("PersWiegandFmtItem", "pers_wiegandFmt", "pers:wiegandFmt", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persWiegandFmt.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersWiegandFmtItemRefresh", "common_op_refresh", "pers:wiegandFmt:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersWiegandFmtItemAdd", "common_op_new", "pers:wiegandFmt:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("PersWiegandFmtItemDel", "common_op_del", "pers:wiegandFmt:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        if ("ZKBioSecurity".equals(this.productCode)) {
            subButtonItem = new AuthPermissionItem("PersWiegandFmtItemTest", "pers_wgFmt_cardFormatTesting", "pers:wiegandFmt:test", "button", "true", Integer.valueOf(4));
            subButtonItem.setParentId(subMenuItem.getId());
            subButtonItem = this.authPermissionService.initData(subButtonItem);
        }
        subButtonItem = new AuthPermissionItem("PersWiegandFmtItemEdit", "common_op_edit", "pers:wiegandFmt:edit", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("PersCardIssue", "pers_card_issue", "pers:issueCard", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("persIssueCard.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("PersCardIssueRefresh", "common_op_refresh", "pers:issueCard:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.initData(subButtonItem);
    }

    public void initPersWiegandFmtItem() {
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(I18nUtil.i18nCode((String)"pers_wiegandFmt_isDefaultFmt", (Object[])new Object[0]), Short.valueOf((short)0), Short.valueOf((short)0), "", "", Boolean.valueOf(false), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0]) + "26", Short.valueOf((short)1), Short.valueOf((short)26), "pccccccccccccccccccccccccp", "eeeeeeeeeeeeeooooooooooooo", Boolean.valueOf(true), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0]) + "26a", Short.valueOf((short)1), Short.valueOf((short)26), "pssssssssccccccccccccccccp", "eeeeeeeeeeeeeooooooooooooo", Boolean.valueOf(false), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0]) + "34", Short.valueOf((short)1), Short.valueOf((short)34), "pccccccccccccccccccccccccccccccccp", "eeeeeeeeeeeeeeeeeooooooooooooooooo", Boolean.valueOf(true), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0]) + "34a", Short.valueOf((short)1), Short.valueOf((short)34), "pssssssssssssssssccccccccccccccccp", "eeeeeeeeeeeeeeeeeooooooooooooooooo", Boolean.valueOf(false), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0]) + "36", Short.valueOf((short)1), Short.valueOf((short)36), "pssssssssssssssssccccccccccccccccccp", "oooooooooooooooeeeeeeeeeeeeeeeeeeeee", Boolean.valueOf(true), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0]) + "37", Short.valueOf((short)1), Short.valueOf((short)37), "psssssssssssssssscccccccccccccccccccp", "eeeeeeeeeeeeeeeeeeboooooooooooooooooo", Boolean.valueOf(true), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0]) + "37a", Short.valueOf((short)1), Short.valueOf((short)37), "pmmmmsssssssssssscccccccccccccccccccp", "eeeeeeeeeeeeeeeeeeooooooooooooooooooo", Boolean.valueOf(false), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0]) + "50", Short.valueOf((short)1), Short.valueOf((short)50), "pssssssssssssssssccccccccccccccccccccccccccccccccp", "eeeeeeeeeeeeeeeeeeeeeeeeeooooooooooooooooooooooooo", Boolean.valueOf(true), "0", Boolean.valueOf(true)));
        this.persWiegandFmtService.initData(new PersWiegandFmtItem(I18nUtil.i18nCode((String)"pers_wgFmt_wg", (Object[])new Object[0]) + "66", Short.valueOf((short)1), Short.valueOf((short)66), "pccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccp", "eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeooooooooooooooooooooooooooooooooo", Boolean.valueOf(true), "0", Boolean.valueOf(true)));
    }

    public void initPersParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("pers.userDataFolder.photo", "/pers/photo", "\u4eba\u5458\u7167\u7247"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.personSupportFakeDel", "true", "\u662f\u5426\u652f\u6301\u5047\u5220"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.pinLen", "9", "pin\u7684\u957f\u5ea6"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.pinSupportLetter", "false", "\u62fc\u53f7\u662f\u5426\u652f\u6301\u5b57\u6bcd"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.pinSupportDefault", "false", "pin\u53f7\u662f\u5426\u9ed8\u8ba4"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.pinSupportIncrement", "true", "pin\u53f7\u662f\u5426\u81ea\u52a8\u589e\u957f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardLen", "32", "\u5361\u53f7\u957f\u5ea6\uff0c\u9ed8\u8ba432\u4f4d"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.siteCodeLen", "20", "siteCode\u7684\u957f\u5ea6"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardSupportLetter", "false", "\u5361\u53f7\u662f\u5426\u652f\u6301\u5b57\u6bcd"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.readIdCard", "false", "\u5237\u8eab\u4efd\u8bc1"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.physicalNoToCardNo", "false", "\u8eab\u4efd\u8bc1\u7269\u7406\u5361\u53f7\u5f53\u5361\u53f7"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardHex", "0", "\u5361\u8fdb\u5236\u663e\u793a 0\uff1a\u4e3a\u5341\u8fdb\u5236\u30011\uff1a\u4e3a\u5341\u516d\u8fdb\u5236"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.showDept", "true", "\u662f\u5426\u663e\u793a\u4eba\u5458\u548c\u90e8\u95e8\u7684\u90e8\u95e8\u6811"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardTempalteCode", "default", "\u9ed8\u8ba4\u5236\u5361\u6a21\u677f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardsSupport", "false", "\u662f\u5426\u652f\u6301\u591a\u5361"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.cardsReadMode", "1", "\u5361\u53f7\u8bfb\u53d6\u65b9\u5f0f 1\uff1a\u63a7\u5236\u5668\u8bfb\u5934\u30012\uff1aID180\uff08\u8bfb\u8eab\u4efd\u8bc1\u7269\u7406\u5361\u53f7\uff09"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.IDReadMode", "1", "\u8eab\u4efd\u8bc1\u8bfb\u5934\u65b9\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.ocrDriveVerson", "2", "ocr\u9a71\u52a8\u7248\u672c"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.pinRetain", "true", "\u79bb\u804c\u4eba\u5458\u662f\u5426\u4fdd\u7559\u7f16\u53f7"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.employeeRegistrar", "true", "\u662f\u5426\u542f\u7528\u5458\u5de5\u767b\u8bb0"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.tempPerson.audit", "1", "\u662f\u5426\u76f4\u63a5\u5ba1\u6838\u901a\u8fc7"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.ocrCertNoType", "1", "ocr\u56de\u586b\u8bc1\u4ef6\u53f7\u7801\u7c7b\u578b"));
        this.baseSysParamService.initData(new BaseSysParamItem("pers.tempPerson.urlCreate", "", "\u4e8c\u7ef4\u7801url"));
    }

    public void initPrintTemplate() {
        BasePrintTemplateItem basePrintTemplateItem = new BasePrintTemplateItem();
        basePrintTemplateItem = this.basePrintTemplateService.initData(new BasePrintTemplateItem(I18nUtil.i18nCode((String)"base_printTemplate_persDefalut", (Object[])new Object[0]), BasePrintTemplateConstants.TEMPLATE_VERTICAL_DEFAULT + this.language, Integer.valueOf(635), Integer.valueOf(1010), "pers", Short.valueOf(BasePrintTemplateConstants.TEMPLATE_VERTICAL), Boolean.valueOf(true)));
        this.initVerticalPrintParam(basePrintTemplateItem.getId());
        basePrintTemplateItem = this.basePrintTemplateService.initData(new BasePrintTemplateItem(I18nUtil.i18nCode((String)"base_printTemplate_persDefalutHZ", (Object[])new Object[0]), BasePrintTemplateConstants.TEMPLATE_HORIZONTAL_DEFAULT + this.language, Integer.valueOf(1010), Integer.valueOf(635), "pers", Short.valueOf(BasePrintTemplateConstants.TEMPLATE_HORIZONTAL), Boolean.valueOf(true)));
        this.initHorizontalPrintParam(basePrintTemplateItem.getId());
    }

    private void initVerticalPrintParam(String templateId) {
        ArrayList<BasePrintParamItem> basePrintParamItemList = new ArrayList<BasePrintParamItem>();
        if (!this.language.equalsIgnoreCase("zh_CN")) {
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "635", "1010", "background", "/images/printTemplate/defaultTempUS_front.jpg"));
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "0", "635", "1010", "background", "/images/printTemplate/verticalUS_opposite.jpg"));
        } else {
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "635", "1010", "background", "/images/printTemplate/defaultTemp_front.jpg"));
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "0", "635", "1010", "background", "/images/printTemplate/vertical_opposite.jpg"));
        }
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.photo", "100px", "140px", "100", "130", "photo", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_photo", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.name", "122px", "313px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_wholeName", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.department", "122px", "350px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_dept", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.pin", "122px", "385px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"pers_person_pin", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.entryDate", "122px", "420px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_entryDate", (Object[])new Object[0])));
        this.basePrintParamService.saveItemList(basePrintParamItemList);
    }

    private void initHorizontalPrintParam(String templateId) {
        ArrayList<BasePrintParamItem> basePrintParamItemList = new ArrayList<BasePrintParamItem>();
        if (!this.language.equalsIgnoreCase("zh_CN")) {
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "1010", "635", "background", "/images/printTemplate/defaultTempHUS_front.jpg"));
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "0", "1010", "635", "background", "/images/printTemplate/horizontalUS_opposite.jpg"));
        } else {
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "1010", "635", "background", "/images/printTemplate/defaultTempH_front.jpg"));
            basePrintParamItemList.add(new BasePrintParamItem(templateId, "0", "1010", "635", "background", "/images/printTemplate/horizontal_opposite.jpg"));
        }
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.photo", "50px", "130px", "100", "130", "photo", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_photo", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.name", "282px", "142px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_wholeName", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.department", "282px", "177px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_dept", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.pin", "282px", "212px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"pers_person_pin", (Object[])new Object[0])));
        basePrintParamItemList.add(new BasePrintParamItem(templateId, "1", "printData.person.entryDate", "282px", "247px", "100", "20", "text", "draggable ui-draggable", "0,0,0", "18px", "center", "Arial,\u5fae\u8f6f\u96c5\u9ed1", I18nUtil.i18nCode((String)"base_printTemplate_entryDate", (Object[])new Object[0])));
        this.basePrintParamService.saveItemList(basePrintParamItemList);
    }

    private void initAppMenus() {
        AuthPermissionItem appModuleItem = null;
        AuthPermissionItem appMenuItem = null;
        AuthPermissionItem appButtonItem = null;
        appModuleItem = this.authPermissionService.getItemByCode("App");
        if (null == appModuleItem) {
            appModuleItem = new AuthPermissionItem("App", "app_module", "app", "app_system", "true", Integer.valueOf(998));
            this.authPermissionService.initData(appModuleItem);
        }
        appMenuItem = new AuthPermissionItem("AppPers", "app_pers", "app:APPpers", "app_menu", "true", Integer.valueOf(1));
        appMenuItem.setParentId(appModuleItem.getId());
        appMenuItem = this.authPermissionService.initData(appMenuItem);
        appButtonItem = new AuthPermissionItem("AppPersList", "app_pers_list", "app:APPpersList", "app_button", "true", Integer.valueOf(1));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppPersAdd", "app_pers_add", "app:APPpersAdd", "app_button", "true", Integer.valueOf(2));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
        appButtonItem = new AuthPermissionItem("AppPersSet", "app_pers_set", "app:APPpersSet", "app_button", "true", Integer.valueOf(3));
        appButtonItem.setParentId(appMenuItem.getId());
        this.authPermissionService.initData(appButtonItem);
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"pers");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("PersUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("PersUpgradeVersion", curVersion, "Pers Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

