/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.annotation.Where;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="VIS_VISITOR_LEVEL t LEFT JOIN VIS_TRANSACTION v ON t.VIS_TRANSACTION_ID=v.ID")
@Where(after="AND v.VISIT_STATE <> 1")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class VisVisitorLevelItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="v.VIS_EMP_PIN")
    @GridColumn(label="vis_emp_pin", width="100")
    private String pin;
    @Column(name="v.VIS_EMP_NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String name;
    @Column(name="v.VIS_EMP_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'")
    private String lastName;
    @Column(name="v.CARD_NO")
    @GridColumn(label="pers_card_cardNo", width="100")
    private String cardNo;
    @Column(name="t.VIS_LEVEL_ID")
    private String levelId;
    private String levelName;
    private String levelModule;
    @Condition(value="(LOWER (v.VIS_EMP_NAME) LIKE LOWER (''%{0}%'') OR LOWER (v.VIS_EMP_LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="(v.CARD_NO LIKE ''%{0}%'' OR v.VIS_EMP_NAME LIKE ''%{0}%'' OR v.VIS_EMP_PIN LIKE ''%{0}%'')")
    private String filter;

    public VisVisitorLevelItem setId(String id) {
        this.id = id;
        return this;
    }

    public VisVisitorLevelItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public VisVisitorLevelItem setName(String name) {
        this.name = name;
        return this;
    }

    public VisVisitorLevelItem setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public VisVisitorLevelItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public VisVisitorLevelItem setLevelId(String levelId) {
        this.levelId = levelId;
        return this;
    }

    public VisVisitorLevelItem setLevelName(String levelName) {
        this.levelName = levelName;
        return this;
    }

    public VisVisitorLevelItem setLevelModule(String levelModule) {
        this.levelModule = levelModule;
        return this;
    }

    public VisVisitorLevelItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public VisVisitorLevelItem setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public String getLevelId() {
        return this.levelId;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public String getLevelModule() {
        return this.levelModule;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getFilter() {
        return this.filter;
    }
}

