/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ATT_LEAVE t LEFT JOIN ATT_LEAVETYPE alt ON alt.ID = t.LEAVETYPE_ID LEFT JOIN ATT_PERSON p ON t.PERS_PERSON_ID=p.PERS_PERSON_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={@GridOperate(type="del", permission="att:leave:del", url="attLeave.do?del&pins=(personPin)", label="common_op_del", filter="attApplyShowDel"), @GridOperate(type="custom", permission="att:leave:image", click="openLeaveImage", label="att_leave_image")})
public class AttLeaveItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERS_PERSON_PIN", equalTag="=")
    @GridColumn(label="att_person_pin", width="120")
    private String personPin;
    @Column(name="p.PERS_PERSON_NAME")
    @GridColumn(label="att_person_name", width="120")
    private String personName;
    @Column(name="p.PERS_PERSON_LASTNAME")
    @GridColumn(label="att_person_lastName", showExpression="#language!='zh_CN'", width="100")
    private String personLastName;
    @Column(name="t.AUTH_DEPT_CODE")
    @GridColumn(label="att_common_deptNo", width="150")
    private String deptCode;
    @Column(name="t.AUTH_DEPT_NAME")
    @GridColumn(label="att_common_deptName", width="120")
    private String deptName;
    @Column(name="alt.LEAVETYPE_NAME")
    @GridColumn(label="att_leave_arilName", width="120", i18n=true, sort="na")
    private String leaveTypeName;
    private String leaveTypeNo;
    @Column(name="t.START_DATETIME")
    @GridColumn(label="common_startTime", width="130")
    private Date startDatetime;
    @Column(name="t.END_DATETIME")
    @GridColumn(label="common_endTime", width="130")
    private Date endDatetime;
    @Column(name="t.LEAVE_LONG")
    @GridColumn(label="att_leave_leaveLongMinute", width="170")
    private Integer leaveLong;
    @GridColumn(label="att_leave_leaveLongHour", width="150", sort="na")
    private String leaveLongHour;
    @GridColumn(label="att_leave_leaveLongDay", width="150", show=false)
    private String leaveLongDay;
    @Column(name="t.REMARK")
    @GridColumn(label="common_remark", width="100")
    private String remark;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="att_common_operateTime", width="150")
    private Date operateDatetime;
    @Column(name="LEAVE_IMAGE_PATH")
    private String leaveImagePath;
    @Column(name="t.AUTH_DEPT_ID")
    private String deptId;
    @Column(name="t.LEAVETYPE_ID")
    private String leaveTypeId;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.PERS_PERSON_ID", equalTag="in")
    private String inPersonId;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;
    @Condition(value="(lower(p.PERS_PERSON_NAME) LIKE ''%{0}%'' OR lower(p.PERS_PERSON_LASTNAME) LIKE ''%{0}%'')")
    private String likeName;
    @Column(name="t.BUSINESS_KEY")
    private String businessKey;
    private String applyNo;
    private String applyType;
    @Column(name="t.FLOW_STATUS", equalTag="=")
    private String flowStatus;
    private String flowNo;
    private String notifierPerIds;
    private String notifierPins;
    @Condition(value="t.END_DATETIME", equalTag=">=")
    private Date startApplyDateTime;
    @Condition(value="t.START_DATETIME", equalTag="<=")
    private Date endApplyDateTime;
    private String photoUrlList;

    public AttLeaveItem() {
    }

    public AttLeaveItem(Boolean equals) {
        super(equals);
    }

    public AttLeaveItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AttLeaveItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttLeaveItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AttLeaveItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AttLeaveItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AttLeaveItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttLeaveItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttLeaveItem setLeaveTypeName(String leaveTypeName) {
        this.leaveTypeName = leaveTypeName;
        return this;
    }

    public AttLeaveItem setLeaveTypeNo(String leaveTypeNo) {
        this.leaveTypeNo = leaveTypeNo;
        return this;
    }

    public AttLeaveItem setStartDatetime(Date startDatetime) {
        this.startDatetime = startDatetime;
        return this;
    }

    public AttLeaveItem setEndDatetime(Date endDatetime) {
        this.endDatetime = endDatetime;
        return this;
    }

    public AttLeaveItem setLeaveLong(Integer leaveLong) {
        this.leaveLong = leaveLong;
        return this;
    }

    public AttLeaveItem setLeaveLongHour(String leaveLongHour) {
        this.leaveLongHour = leaveLongHour;
        return this;
    }

    public AttLeaveItem setLeaveLongDay(String leaveLongDay) {
        this.leaveLongDay = leaveLongDay;
        return this;
    }

    public AttLeaveItem setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public AttLeaveItem setOperateDatetime(Date operateDatetime) {
        this.operateDatetime = operateDatetime;
        return this;
    }

    public AttLeaveItem setLeaveImagePath(String leaveImagePath) {
        this.leaveImagePath = leaveImagePath;
        return this;
    }

    public AttLeaveItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttLeaveItem setLeaveTypeId(String leaveTypeId) {
        this.leaveTypeId = leaveTypeId;
        return this;
    }

    public AttLeaveItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public AttLeaveItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttLeaveItem setInPersonId(String inPersonId) {
        this.inPersonId = inPersonId;
        return this;
    }

    public AttLeaveItem setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
        return this;
    }

    public AttLeaveItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AttLeaveItem setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    public AttLeaveItem setApplyNo(String applyNo) {
        this.applyNo = applyNo;
        return this;
    }

    public AttLeaveItem setApplyType(String applyType) {
        this.applyType = applyType;
        return this;
    }

    public AttLeaveItem setFlowStatus(String flowStatus) {
        this.flowStatus = flowStatus;
        return this;
    }

    public AttLeaveItem setFlowNo(String flowNo) {
        this.flowNo = flowNo;
        return this;
    }

    public AttLeaveItem setNotifierPerIds(String notifierPerIds) {
        this.notifierPerIds = notifierPerIds;
        return this;
    }

    public AttLeaveItem setNotifierPins(String notifierPins) {
        this.notifierPins = notifierPins;
        return this;
    }

    public AttLeaveItem setStartApplyDateTime(Date startApplyDateTime) {
        this.startApplyDateTime = startApplyDateTime;
        return this;
    }

    public AttLeaveItem setEndApplyDateTime(Date endApplyDateTime) {
        this.endApplyDateTime = endApplyDateTime;
        return this;
    }

    public AttLeaveItem setPhotoUrlList(String photoUrlList) {
        this.photoUrlList = photoUrlList;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getLeaveTypeName() {
        return this.leaveTypeName;
    }

    public String getLeaveTypeNo() {
        return this.leaveTypeNo;
    }

    public Date getStartDatetime() {
        return this.startDatetime;
    }

    public Date getEndDatetime() {
        return this.endDatetime;
    }

    public Integer getLeaveLong() {
        return this.leaveLong;
    }

    public String getLeaveLongHour() {
        return this.leaveLongHour;
    }

    public String getLeaveLongDay() {
        return this.leaveLongDay;
    }

    public String getRemark() {
        return this.remark;
    }

    public Date getOperateDatetime() {
        return this.operateDatetime;
    }

    public String getLeaveImagePath() {
        return this.leaveImagePath;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getLeaveTypeId() {
        return this.leaveTypeId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getInPersonId() {
        return this.inPersonId;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getApplyNo() {
        return this.applyNo;
    }

    public String getApplyType() {
        return this.applyType;
    }

    public String getFlowStatus() {
        return this.flowStatus;
    }

    public String getFlowNo() {
        return this.flowNo;
    }

    public String getNotifierPerIds() {
        return this.notifierPerIds;
    }

    public String getNotifierPins() {
        return this.notifierPins;
    }

    public Date getStartApplyDateTime() {
        return this.startApplyDateTime;
    }

    public Date getEndApplyDateTime() {
        return this.endApplyDateTime;
    }

    public String getPhotoUrlList() {
        return this.photoUrlList;
    }
}

