/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDFaceConsumeDeviceLogRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDDeviceService;
import com.zkteco.zkbiosecurity.posid.service.PosIDFaceConsumeDeviceLogService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDeviceItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDFaceConsumeDeviceLogItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDFaceConsumeDeviceLogController
extends ExportController
implements PosIDFaceConsumeDeviceLogRemote {
    @Autowired
    private PosIDFaceConsumeDeviceLogService posIDFaceConsumeDeviceLogService;
    @Autowired
    private PosIDDeviceService posIDDeviceService;

    @RequiresPermissions(value={"posid:faceConsumeDevice:getLog"})
    public ModelAndView index(String deviceId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("deviceId", deviceId);
        return new ModelAndView("posid/faceConsumeDeviceLog/posIDFaceConsumeDeviceLog", param);
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:getLog"})
    public DxGrid list(String deviceId) {
        PosIDDeviceItem posIDDeviceItem = this.posIDDeviceService.getItemById(deviceId);
        Pager pager = null != posIDDeviceItem ? this.posIDFaceConsumeDeviceLogService.getList(posIDDeviceItem.getSn(), this.getPageNo(), this.getPageSize()) : new Pager(this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, PosIDFaceConsumeDeviceLogItem.class);
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:logDel"})
    public ZKResultMsg delByDeviceId(String deviceId) {
        PosIDDeviceItem posIDDeviceItem = this.posIDDeviceService.getItemById(deviceId);
        if (null == posIDDeviceItem) {
            return ZKResultMsg.failMsg();
        }
        return this.posIDFaceConsumeDeviceLogService.delByDeviceId(posIDDeviceItem.getSn());
    }

    @RequiresPermissions(value={"posid:faceConsumeDevice:getLog"})
    public void downLoadFiles(String sn, String date, String fileName) throws Exception {
        String filePath = "\\upload\\posID\\DevLog\\" + sn + "\\" + date + "\\" + fileName;
        File file = new File(FileUtil.getLocalFullPath((String)filePath));
        if (file.exists()) {
            this.response = FileUtil.downloadZip((File)file, (HttpServletResponse)this.response);
            this.response.flushBuffer();
        }
    }
}

