/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

public class Parser {
    public static int parseSingleQuotes(char[] query, int offset, boolean standardConformingStrings) {
        if (standardConformingStrings && offset >= 2 && (query[offset - 1] == 'e' || query[offset - 1] == 'E') && Parser.charTerminatesIdentifier(query[offset - 2])) {
            standardConformingStrings = false;
        }
        if (standardConformingStrings) {
            while (++offset < query.length) {
                switch (query[offset]) {
                    case '\'': {
                        return offset;
                    }
                }
            }
        } else {
            block8: while (++offset < query.length) {
                switch (query[offset]) {
                    case '\\': {
                        ++offset;
                        continue block8;
                    }
                    case '\'': {
                        return offset;
                    }
                }
            }
        }
        return query.length;
    }

    public static int parseDoubleQuotes(char[] query, int offset) {
        while (++offset < query.length && query[offset] != '\"') {
        }
        return offset;
    }

    public static int parseDollarQuotes(char[] query, int offset) {
        if (!(offset + 1 >= query.length || offset != 0 && Parser.isIdentifierContChar(query[offset - 1]))) {
            int endIdx = -1;
            if (query[offset + 1] == '$') {
                endIdx = offset + 1;
            } else if (Parser.isDollarQuoteStartChar(query[offset + 1])) {
                for (int d2 = offset + 2; d2 < query.length; ++d2) {
                    if (query[d2] == '$') {
                        endIdx = d2;
                        break;
                    }
                    if (!Parser.isDollarQuoteContChar(query[d2])) break;
                }
            }
            if (endIdx > 0) {
                int tagIdx = offset;
                int tagLen = endIdx - offset + 1;
                offset = endIdx;
                ++offset;
                while (offset < query.length) {
                    if (query[offset] == '$' && Parser.subArraysEqual(query, tagIdx, offset, tagLen)) {
                        offset += tagLen - 1;
                        break;
                    }
                    ++offset;
                }
            }
        }
        return offset;
    }

    public static int parseLineComment(char[] query, int offset) {
        block1: {
            if (offset + 1 >= query.length || query[offset + 1] != '-') break block1;
            while (++offset < query.length && query[offset] != '\r' && query[offset] != '\n') {
            }
        }
        return offset;
    }

    public static int parseBlockComment(char[] query, int offset) {
        if (offset + 1 < query.length && query[offset + 1] == '*') {
            int level = 1;
            offset += 2;
            while (offset < query.length) {
                switch (query[offset - 1]) {
                    case '*': {
                        if (query[offset] != '/') break;
                        --level;
                        ++offset;
                        break;
                    }
                    case '/': {
                        if (query[offset] != '*') break;
                        ++level;
                        ++offset;
                        break;
                    }
                }
                if (level == 0) {
                    --offset;
                    break;
                }
                ++offset;
            }
        }
        return offset;
    }

    public static boolean isSpace(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 == '\f';
    }

    public static boolean isOperatorChar(char c2) {
        return ",()[].;:+-*/%^<>=~!@#&|`?".indexOf(c2) != -1;
    }

    public static boolean isIdentifierStartChar(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '_' || c2 > '\u007f';
    }

    public static boolean isIdentifierContChar(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '_' || c2 > '\u007f' || c2 >= '0' && c2 <= '9' || c2 == '$';
    }

    public static boolean charTerminatesIdentifier(char c2) {
        return c2 == '\"' || Parser.isSpace(c2) || Parser.isOperatorChar(c2);
    }

    public static boolean isDollarQuoteStartChar(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '_' || c2 > '\u007f';
    }

    public static boolean isDollarQuoteContChar(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '_' || c2 > '\u007f' || c2 >= '0' && c2 <= '9';
    }

    private static boolean subArraysEqual(char[] arr, int offA, int offB, int len) {
        if (offA < 0 || offB < 0 || offA >= arr.length || offB >= arr.length || offA + len > arr.length || offB + len > arr.length) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (arr[offA + i2] == arr[offB + i2]) continue;
            return false;
        }
        return true;
    }
}

