/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.Column;
import com.microsoft.sqlserver.jdbc.SQLIdentifier;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.StreamColInfo;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.StreamTabName;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TypeInfo;

final class StreamColumns
extends StreamPacket {
    private Column[] columns;

    StreamColumns() {
        super(129);
    }

    @Override
    void setFromTDS(TDSReader tDSReader) throws SQLServerException {
        if (129 != tDSReader.readUnsignedByte()) assert (false);
        int n2 = tDSReader.readUnsignedShort();
        if (65535 == n2) {
            return;
        }
        this.columns = new Column[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeInfo typeInfo = TypeInfo.getInstance(tDSReader);
            SQLIdentifier sQLIdentifier = new SQLIdentifier();
            if (SSType.TEXT == typeInfo.getSSType() || SSType.NTEXT == typeInfo.getSSType() || SSType.IMAGE == typeInfo.getSSType()) {
                if (tDSReader.getConnection().isYukonOrLater()) {
                    sQLIdentifier = tDSReader.readSQLIdentifier();
                } else {
                    sQLIdentifier = new SQLIdentifier();
                    sQLIdentifier.setObjectName(tDSReader.readUnicodeString(tDSReader.readUnsignedShort()));
                }
            }
            String string = tDSReader.readUnicodeString(tDSReader.readUnsignedByte());
            this.columns[i2] = new Column(typeInfo, string, sQLIdentifier);
        }
    }

    Column[] buildColumns(StreamColInfo streamColInfo, StreamTabName streamTabName) throws SQLServerException {
        if (null != streamColInfo && null != streamTabName) {
            streamTabName.applyTo(this.columns, streamColInfo.applyTo(this.columns));
        }
        return this.columns;
    }
}

