/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AsciiFilteredInputStream;
import com.microsoft.sqlserver.jdbc.AsciiFilteredUnicodeInputStream;
import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.GregorianChange;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerBlob;
import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerNClob;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.StreamType;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.UTC;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import microsoft.sql.DateTimeOffset;

final class DDC {
    private static final BigInteger maxRPCDecimalValue = new BigInteger("99999999999999999999999999999999999999");

    DDC() {
    }

    static final Object convertIntegerToObject(int n2, int n3, JDBCType jDBCType, StreamType streamType) {
        switch (jDBCType) {
            case INTEGER: {
                return new Integer(n2);
            }
            case SMALLINT: 
            case TINYINT: {
                return new Short((short)n2);
            }
            case BIT: 
            case BOOLEAN: {
                return new Boolean(0 != n2);
            }
            case BIGINT: {
                return new Long(n2);
            }
            case DECIMAL: 
            case NUMERIC: {
                return new BigDecimal(Integer.toString(n2));
            }
            case FLOAT: 
            case DOUBLE: {
                return new Double(n2);
            }
            case REAL: {
                return new Float(n2);
            }
            case BINARY: {
                return DDC.convertIntToBytes(n2, n3);
            }
        }
        return Integer.toString(n2);
    }

    static final Object convertLongToObject(long l2, JDBCType jDBCType, StreamType streamType) {
        switch (jDBCType) {
            case BIGINT: {
                return new Long(l2);
            }
            case INTEGER: {
                return new Integer((int)l2);
            }
            case SMALLINT: 
            case TINYINT: {
                return new Short((short)l2);
            }
            case BIT: 
            case BOOLEAN: {
                return new Boolean(0L != l2);
            }
            case DECIMAL: 
            case NUMERIC: {
                return new BigDecimal(Long.toString(l2));
            }
            case FLOAT: 
            case DOUBLE: {
                return new Double(l2);
            }
            case REAL: {
                return new Float(l2);
            }
            case BINARY: {
                return DDC.convertLongToBytes(l2);
            }
        }
        return Long.toString(l2);
    }

    static final byte[] convertIntToBytes(int n2, int n3) {
        byte[] byArray = new byte[n3];
        int n4 = n3;
        while (n4-- > 0) {
            byArray[n4] = (byte)(n2 & 0xFF);
            n2 >>= 8;
        }
        return byArray;
    }

    static final Object convertFloatToObject(float f2, JDBCType jDBCType, StreamType streamType) {
        switch (jDBCType) {
            case REAL: {
                return new Float(f2);
            }
            case INTEGER: {
                return new Integer((int)f2);
            }
            case SMALLINT: 
            case TINYINT: {
                return new Short((short)f2);
            }
            case BIT: 
            case BOOLEAN: {
                return new Boolean(0 != Float.compare(0.0f, f2));
            }
            case BIGINT: {
                return new Long((long)f2);
            }
            case DECIMAL: 
            case NUMERIC: {
                return new BigDecimal(Float.toString(f2));
            }
            case FLOAT: 
            case DOUBLE: {
                return new Double(new Float(f2).doubleValue());
            }
            case BINARY: {
                return DDC.convertIntToBytes(Float.floatToRawIntBits(f2), 4);
            }
        }
        return Float.toString(f2);
    }

    static final byte[] convertLongToBytes(long l2) {
        byte[] byArray = new byte[8];
        int n2 = 8;
        while (n2-- > 0) {
            byArray[n2] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
        return byArray;
    }

    static final Object convertDoubleToObject(double d2, JDBCType jDBCType, StreamType streamType) {
        switch (jDBCType) {
            case FLOAT: 
            case DOUBLE: {
                return new Double(d2);
            }
            case REAL: {
                return new Float(new Double(d2).floatValue());
            }
            case INTEGER: {
                return new Integer((int)d2);
            }
            case SMALLINT: 
            case TINYINT: {
                return new Short((short)d2);
            }
            case BIT: 
            case BOOLEAN: {
                return new Boolean(0 != Double.compare(0.0, d2));
            }
            case BIGINT: {
                return new Long((long)d2);
            }
            case DECIMAL: 
            case NUMERIC: {
                return new BigDecimal(Double.toString(d2));
            }
            case BINARY: {
                return DDC.convertLongToBytes(Double.doubleToRawLongBits(d2));
            }
        }
        return Double.toString(d2);
    }

    static final byte[] convertBigDecimalToBytes(BigDecimal bigDecimal, int n2) {
        byte[] byArray;
        if (bigDecimal == null) {
            byArray = new byte[]{(byte)n2, 0};
        } else {
            boolean bl;
            boolean bl2 = bl = bigDecimal.signum() < 0;
            if (bigDecimal.scale() < 0) {
                bigDecimal = bigDecimal.setScale(0);
            }
            BigInteger bigInteger = bigDecimal.unscaledValue();
            if (bl) {
                bigInteger = bigInteger.negate();
            }
            byte[] byArray2 = bigInteger.toByteArray();
            byArray = new byte[byArray2.length + 3];
            int n3 = 0;
            byArray[n3++] = (byte)bigDecimal.scale();
            byArray[n3++] = (byte)(byArray2.length + 1);
            byArray[n3++] = (byte)(!bl ? 1 : 0);
            for (int i2 = byArray2.length - 1; i2 >= 0; --i2) {
                byArray[n3++] = byArray2[i2];
            }
        }
        return byArray;
    }

    static final Object convertBigDecimalToObject(BigDecimal bigDecimal, JDBCType jDBCType, StreamType streamType) {
        switch (jDBCType) {
            case DECIMAL: 
            case NUMERIC: {
                return bigDecimal;
            }
            case FLOAT: 
            case DOUBLE: {
                return new Double(bigDecimal.doubleValue());
            }
            case REAL: {
                return new Float(bigDecimal.floatValue());
            }
            case INTEGER: {
                return new Integer(bigDecimal.intValue());
            }
            case SMALLINT: 
            case TINYINT: {
                return new Short(bigDecimal.shortValue());
            }
            case BIT: 
            case BOOLEAN: {
                return new Boolean(0 != bigDecimal.compareTo(BigDecimal.valueOf(0L)));
            }
            case BIGINT: {
                return new Long(bigDecimal.longValue());
            }
            case BINARY: {
                return DDC.convertBigDecimalToBytes(bigDecimal, bigDecimal.scale());
            }
        }
        return bigDecimal.toString();
    }

    static final Object convertStringToObject(String string, String string2, JDBCType jDBCType, StreamType streamType) throws UnsupportedEncodingException, IllegalArgumentException {
        switch (jDBCType) {
            case DECIMAL: 
            case NUMERIC: {
                return new BigDecimal(string.trim());
            }
            case FLOAT: 
            case DOUBLE: {
                return Double.valueOf(string.trim());
            }
            case REAL: {
                return Float.valueOf(string.trim());
            }
            case INTEGER: {
                return Integer.valueOf(string.trim());
            }
            case SMALLINT: 
            case TINYINT: {
                return Short.valueOf(string.trim());
            }
            case BIT: 
            case BOOLEAN: {
                String string3 = string.trim();
                return 1 == string3.length() ? Boolean.valueOf('1' == string3.charAt(0)) : Boolean.valueOf(string3);
            }
            case BIGINT: {
                return Long.valueOf(string.trim());
            }
            case TIMESTAMP: {
                return Timestamp.valueOf(string.trim());
            }
            case DATE: {
                return Date.valueOf(DDC.getDatePart(string.trim()));
            }
            case TIME: {
                Timestamp timestamp = Timestamp.valueOf("1970-01-01 " + DDC.getTimePart(string.trim()));
                GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
                gregorianCalendar.clear();
                gregorianCalendar.setTimeInMillis(timestamp.getTime());
                if (timestamp.getNanos() % 1000000 >= 500000) {
                    gregorianCalendar.add(14, 1);
                }
                gregorianCalendar.set(1970, 0, 1);
                return new Time(gregorianCalendar.getTimeInMillis());
            }
            case BINARY: {
                return string.getBytes(string2);
            }
        }
        switch (streamType) {
            case CHARACTER: {
                return new StringReader(string);
            }
            case ASCII: {
                return new ByteArrayInputStream(string.getBytes("US-ASCII"));
            }
            case BINARY: {
                return new ByteArrayInputStream(string.getBytes());
            }
        }
        return string;
    }

    static final Object convertStreamToObject(BaseInputStream baseInputStream, TypeInfo typeInfo, JDBCType jDBCType, InputStreamGetterArgs inputStreamGetterArgs) throws SQLServerException {
        if (null == baseInputStream) {
            return null;
        }
        assert (null != typeInfo);
        assert (null != inputStreamGetterArgs);
        SSType sSType = typeInfo.getSSType();
        try {
            switch (jDBCType) {
                default: {
                    if (SSType.BINARY == sSType || SSType.VARBINARY == sSType || SSType.VARBINARYMAX == sSType || SSType.TIMESTAMP == sSType || SSType.IMAGE == sSType || SSType.UDT == sSType) {
                        if (StreamType.ASCII == inputStreamGetterArgs.streamType) {
                            return baseInputStream;
                        }
                        assert (StreamType.CHARACTER == inputStreamGetterArgs.streamType || StreamType.NONE == inputStreamGetterArgs.streamType);
                        byte[] byArray = baseInputStream.getBytes();
                        String string = Util.bytesToHexString(byArray, byArray.length);
                        if (StreamType.NONE == inputStreamGetterArgs.streamType) {
                            return string;
                        }
                        return new StringReader(string);
                    }
                    if (StreamType.ASCII == inputStreamGetterArgs.streamType) {
                        if (typeInfo.supportsFastAsciiConversion()) {
                            return new AsciiFilteredInputStream(baseInputStream);
                        }
                        if (inputStreamGetterArgs.isAdaptive) {
                            return AsciiFilteredUnicodeInputStream.MakeAsciiFilteredUnicodeInputStream(baseInputStream, new BufferedReader(new InputStreamReader((InputStream)baseInputStream, typeInfo.getCharset())));
                        }
                        return new ByteArrayInputStream(new String(baseInputStream.getBytes(), typeInfo.getCharset()).getBytes("US-ASCII"));
                    }
                    if (StreamType.CHARACTER == inputStreamGetterArgs.streamType || StreamType.NCHARACTER == inputStreamGetterArgs.streamType) {
                        if (inputStreamGetterArgs.isAdaptive) {
                            return new BufferedReader(new InputStreamReader((InputStream)baseInputStream, typeInfo.getCharset()));
                        }
                        return new StringReader(new String(baseInputStream.getBytes(), typeInfo.getCharset()));
                    }
                    return DDC.convertStringToObject(new String(baseInputStream.getBytes(), typeInfo.getCharset()), typeInfo.getCharset(), jDBCType, inputStreamGetterArgs.streamType);
                }
                case CLOB: {
                    return new SQLServerClob(baseInputStream, typeInfo);
                }
                case NCLOB: {
                    return new SQLServerNClob(baseInputStream, typeInfo);
                }
                case SQLXML: {
                    return new SQLServerSQLXML(baseInputStream, inputStreamGetterArgs, typeInfo);
                }
                case BINARY: 
                case VARBINARY: 
                case LONGVARBINARY: 
                case BLOB: 
            }
            if (StreamType.BINARY == inputStreamGetterArgs.streamType) {
                return baseInputStream;
            }
            if (JDBCType.BLOB == jDBCType) {
                return new SQLServerBlob(baseInputStream);
            }
            return baseInputStream.getBytes();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorConvertingValue"));
            throw new SQLServerException(messageFormat.format(new Object[]{typeInfo.getSSType(), jDBCType}), null, 0, (Throwable)illegalArgumentException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorConvertingValue"));
            throw new SQLServerException(messageFormat.format(new Object[]{typeInfo.getSSType(), jDBCType}), null, 0, (Throwable)unsupportedEncodingException);
        }
    }

    private static final String getDatePart(String string) {
        int n2 = string.indexOf(32);
        if (-1 == n2) {
            return string;
        }
        return string.substring(0, n2);
    }

    private static final String getTimePart(String string) {
        int n2 = string.indexOf(32);
        if (-1 == n2) {
            return string;
        }
        return string.substring(n2 + 1);
    }

    private static String fractionalSecondsString(long l2, int n2) {
        assert (0L <= l2 && l2 < 1000000000L);
        assert (0 <= n2 && n2 <= 7);
        if (0 == n2) {
            return "";
        }
        return BigDecimal.valueOf(l2 % 1000000000L, 9).setScale(n2).toPlainString().substring(1);
    }

    static final Object convertTemporalToObject(JDBCType jDBCType, SSType sSType, Calendar calendar, int n2, long l2, int n3) {
        int n4;
        int n5;
        TimeZone timeZone = null != calendar ? calendar.getTimeZone() : TimeZone.getDefault();
        TimeZone timeZone2 = SSType.DATETIMEOFFSET == sSType ? UTC.timeZone : timeZone;
        int n6 = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone2, Locale.US);
        gregorianCalendar.setLenient(true);
        gregorianCalendar.clear();
        switch (sSType) {
            case TIME: {
                gregorianCalendar.set(1900, 0, 1, 0, 0, 0);
                gregorianCalendar.set(14, (int)(l2 / 1000000L));
                n6 = (int)(l2 % 1000000000L);
                break;
            }
            case DATE: 
            case DATETIME2: 
            case DATETIMEOFFSET: {
                if (n2 >= GregorianChange.DAYS_SINCE_BASE_DATE_HINT) {
                    gregorianCalendar.set(1, 0, 1 + n2, 0, 0, 0);
                    gregorianCalendar.set(14, (int)(l2 / 1000000L));
                } else {
                    gregorianCalendar.setGregorianChange(GregorianChange.PURE_CHANGE_DATE);
                    gregorianCalendar.set(1, 0, 1 + n2, 0, 0, 0);
                    gregorianCalendar.set(14, (int)(l2 / 1000000L));
                    n5 = gregorianCalendar.get(1);
                    n4 = gregorianCalendar.get(2);
                    int n7 = gregorianCalendar.get(5);
                    int n8 = gregorianCalendar.get(11);
                    int n9 = gregorianCalendar.get(12);
                    int n10 = gregorianCalendar.get(13);
                    int n11 = gregorianCalendar.get(14);
                    gregorianCalendar.setGregorianChange(GregorianChange.STANDARD_CHANGE_DATE);
                    gregorianCalendar.set(n5, n4, n7, n8, n9, n10);
                    gregorianCalendar.set(14, n11);
                }
                if (SSType.DATETIMEOFFSET == sSType && !timeZone2.hasSameRules(timeZone)) {
                    GregorianCalendar gregorianCalendar2 = new GregorianCalendar(timeZone, Locale.US);
                    gregorianCalendar2.clear();
                    gregorianCalendar2.setTimeInMillis(gregorianCalendar.getTimeInMillis());
                    gregorianCalendar = gregorianCalendar2;
                }
                n6 = (int)(l2 % 1000000000L);
                break;
            }
            case DATETIME: {
                gregorianCalendar.set(1900, 0, 1 + n2, 0, 0, 0);
                gregorianCalendar.set(14, (int)l2);
                n6 = (int)(l2 * 1000000L % 1000000000L);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected SSType: " + (Object)((Object)sSType)));
            }
        }
        switch (jDBCType.category) {
            case DATE: {
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                return new Date(gregorianCalendar.getTimeInMillis());
            }
            case TIME: {
                if (n6 % 1000000 >= 500000) {
                    gregorianCalendar.add(14, 1);
                }
                gregorianCalendar.set(1970, 0, 1);
                return new Time(gregorianCalendar.getTimeInMillis());
            }
            case TIMESTAMP: {
                Timestamp timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
                timestamp.setNanos(n6);
                return timestamp;
            }
            case DATETIMEOFFSET: {
                assert (SSType.DATETIMEOFFSET == sSType);
                n5 = calendar.get(15);
                assert (0 == n5 % 60000);
                Timestamp timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
                timestamp.setNanos(n6);
                return DateTimeOffset.valueOf(timestamp, n5 / 60000);
            }
            case CHARACTER: {
                switch (sSType) {
                    case DATE: {
                        return String.format(Locale.US, "%1$tF", gregorianCalendar);
                    }
                    case TIME: {
                        return String.format(Locale.US, "%1$tT%2$s", gregorianCalendar, DDC.fractionalSecondsString(n6, n3));
                    }
                    case DATETIME2: {
                        return String.format(Locale.US, "%1$tF %1$tT%2$s", gregorianCalendar, DDC.fractionalSecondsString(n6, n3));
                    }
                    case DATETIMEOFFSET: {
                        n5 = calendar.get(15);
                        assert (0 == n5 % 60000);
                        n4 = Math.abs(n5 / 60000);
                        return String.format(Locale.US, "%1$tF %1$tT%2$s %3$c%4$02d:%5$02d", gregorianCalendar, DDC.fractionalSecondsString(n6, n3), Character.valueOf(n5 >= 0 ? (char)'+' : '-'), n4 / 60, n4 % 60);
                    }
                    case DATETIME: {
                        return new Timestamp(gregorianCalendar.getTimeInMillis()).toString();
                    }
                }
                throw new AssertionError((Object)("Unexpected SSType: " + (Object)((Object)sSType)));
            }
        }
        throw new AssertionError((Object)("Unexpected JDBCType: " + (Object)((Object)jDBCType)));
    }

    static int daysSinceBaseDate(int n2, int n3, int n4) {
        assert (n2 >= 1);
        assert (n4 >= 1);
        assert (n3 >= 1);
        return n3 - 1 + (n2 - n4) * 365 + DDC.leapDaysBeforeYear(n2) - DDC.leapDaysBeforeYear(n4);
    }

    private static int leapDaysBeforeYear(int n2) {
        assert (n2 >= 1);
        return (n2 - 1) / 4 - (n2 - 1) / 100 + (n2 - 1) / 400;
    }

    static final boolean exceedsMaxRPCDecimalPrecisionOrScale(BigDecimal bigDecimal) {
        BigInteger bigInteger;
        if (null == bigDecimal) {
            return false;
        }
        if (bigDecimal.scale() > 38) {
            return true;
        }
        BigInteger bigInteger2 = bigInteger = bigDecimal.scale() < 0 ? bigDecimal.setScale(0).unscaledValue() : bigDecimal.unscaledValue();
        if (bigDecimal.signum() < 0) {
            bigInteger = bigInteger.negate();
        }
        return bigInteger.compareTo(maxRPCDecimalValue) > 0;
    }

    static String convertReaderToString(Reader reader, int n2) throws SQLServerException {
        assert (-1 == n2 || n2 >= 0);
        if (null == reader) {
            return null;
        }
        if (0 == n2) {
            return "";
        }
        try {
            int n3;
            StringBuilder stringBuilder = new StringBuilder(-1 != n2 ? n2 : 4000);
            char[] cArray = new char[-1 != n2 && n2 < 4000 ? n2 : 4000];
            while ((n3 = reader.read(cArray, 0, cArray.length)) > 0) {
                if (n3 > cArray.length) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                    Object[] objectArray = new Object[]{SQLServerException.getErrString("R_streamReadReturnedInvalidValue")};
                    SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
                }
                stringBuilder.append(cArray, 0, n3);
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
            Object[] objectArray = new Object[]{iOException.toString()};
            SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
            return null;
        }
    }
}

