/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseInputStream;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;

final class AsciiFilteredUnicodeInputStream
extends InputStream {
    private final Reader containedReader;
    private final Charset asciiCharSet;
    private final byte[] bSingleByte = new byte[1];

    static AsciiFilteredUnicodeInputStream MakeAsciiFilteredUnicodeInputStream(BaseInputStream baseInputStream, Reader reader) throws SQLServerException {
        if (BaseInputStream.logger.isLoggable(Level.FINER)) {
            BaseInputStream.logger.finer(baseInputStream.toString() + " wrapping in AsciiFilteredInputStream");
        }
        return new AsciiFilteredUnicodeInputStream(reader);
    }

    private AsciiFilteredUnicodeInputStream(Reader reader) throws SQLServerException {
        this.containedReader = reader;
        this.asciiCharSet = Charset.forName("US-ASCII");
    }

    @Override
    public void close() throws IOException {
        this.containedReader.close();
    }

    @Override
    public long skip(long l2) throws IOException {
        return this.containedReader.skip(l2);
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public int read() throws IOException {
        int n2 = this.read(this.bSingleByte);
        return -1 == n2 ? -1 : this.bSingleByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        char[] cArray = new char[n3];
        int n4 = this.containedReader.read(cArray);
        if (n4 > 0) {
            if (n4 < n3) {
                n3 = n4;
            }
            ByteBuffer byteBuffer = this.asciiCharSet.encode(CharBuffer.wrap(cArray));
            byteBuffer.get(byArray, n2, n3);
        }
        return n4;
    }

    @Override
    public boolean markSupported() {
        return this.containedReader.markSupported();
    }

    @Override
    public void mark(int n2) {
        try {
            this.containedReader.mark(n2);
        }
        catch (IOException iOException) {
            return;
        }
    }

    @Override
    public void reset() throws IOException {
        this.containedReader.reset();
    }
}

