/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.jdbc;

import com.zkteco.zkbiosecurity.core.config.DataSourceConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class JdbcOperateTemplate {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public void alterTableCharLen(String tableName, String column, String varchartLen) {
        String driver = DataSourceConfig.getDbType().toLowerCase();
        String sql = "";
        if (driver.contains("postgresql")) {
            sql = "ALTER TABLE " + tableName + " ALTER COLUMN " + column + " TYPE VARCHAR(" + varchartLen + ")";
        } else if (driver.contains("sqlserver")) {
            sql = "ALTER TABLE " + tableName + " ALTER COLUMN " + column + "  NVARCHAR(" + varchartLen + ")";
        } else if (driver.contains("oracle")) {
            sql = "ALTER TABLE \"" + tableName + "\" MODIFY \"" + column + "\"  VARCHAR2(" + varchartLen + ")";
        } else if (driver.contains("mysql")) {
            sql = "ALTER TABLE " + tableName + " MODIFY COLUMN " + column + " VARCHAR(" + varchartLen + ")";
        }
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            this.jdbcTemplate.execute(sql.toUpperCase());
        }
    }

    public void alterTableColumnCharToTexts(String tableName, String column) {
        String driver = DataSourceConfig.getDbType().toLowerCase();
        String sql = "";
        if (driver.contains("postgresql")) {
            sql = "ALTER TABLE " + tableName + " ALTER COLUMN " + column + " TYPE TEXT USING " + column + "::TEXT";
            this.jdbcTemplate.execute(sql.toUpperCase());
        } else if (driver.contains("oracle")) {
            sql = "ALTER TABLE " + tableName + " ADD " + column + "_TEMP CLOB";
            this.jdbcTemplate.execute(sql.toUpperCase());
            sql = "UPDATE " + tableName + " SET " + column + "_TEMP = " + column;
            this.jdbcTemplate.execute(sql.toUpperCase());
            sql = "ALTER TABLE " + tableName + " DROP COLUMN " + column;
            this.jdbcTemplate.execute(sql.toUpperCase());
            sql = "ALTER TABLE " + tableName + " RENAME COLUMN " + column + "_TEMP TO " + column;
            this.jdbcTemplate.execute(sql.toUpperCase());
        } else if (driver.contains("sqlserver")) {
            sql = "ALTER TABLE " + tableName + " ALTER COLUMN " + column + " NVARCHAR(MAX)";
            this.jdbcTemplate.execute(sql.toUpperCase());
        } else if (driver.contains("mysql")) {
            sql = "ALTER TABLE " + tableName + " MODIFY COLUMN " + column + " LONGTEXT";
            this.jdbcTemplate.execute(sql.toUpperCase());
        }
    }
}

