/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkShiftDefinitionRemote;
import com.zkteco.zkbiosecurity.park.service.ParkShiftDefinitionService;
import com.zkteco.zkbiosecurity.park.vo.ParkShiftDefinitionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkShiftDefinitionController
extends BaseController
implements ParkShiftDefinitionRemote {
    @Autowired
    private ParkShiftDefinitionService parkShiftDefinitionService;

    @RequiresPermissions(value={"park:shiftDefinition"})
    public ModelAndView index() {
        return new ModelAndView("park/shiftDefinition/parkShiftDefinition");
    }

    @RequiresPermissions(value={"park:shiftDefinition:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkShiftDefinitionService.getItemById(id));
        }
        return new ModelAndView("park/shiftDefinition/editParkShiftDefinition");
    }

    @RequiresPermissions(value={"park:shiftDefinition:edit"})
    @LogRequest(module="park_module", object="park_shift", opType="park_shift_edit", requestParams={"name"}, opContent="park_shift_name")
    public ZKResultMsg save(ParkShiftDefinitionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkShiftDefinitionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"park:shiftDefinition:refresh"})
    public DxGrid list(ParkShiftDefinitionItem codition) {
        Pager pager = this.parkShiftDefinitionService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_shift", opType="park_shift_del", requestParams={"names"}, opContent="park_shift_del")
    @RequiresPermissions(value={"park:shiftDefinition:del"})
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkShiftDefinitionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isNotExist(@RequestParam(value="name", required=false) String name) {
        return this.parkShiftDefinitionService.isNotExist(name);
    }

    public ZKResultMsg getAllShiftDefinition() {
        List selectItems = this.parkShiftDefinitionService.getAllShiftDefinition();
        return new ZKResultMsg((Object)selectItems);
    }
}

