/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkRecordoutSideRemote;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutSideService;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordoutSideItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkRecordoutSideController
extends BaseController
implements ParkRecordoutSideRemote {
    @Autowired
    private ParkRecordoutSideService parkRecordoutSideService;
    @Autowired
    private ParkParamsService parkParamsService;

    @RequiresPermissions(value={"park:recordoutSide"})
    public ModelAndView index() {
        return new ModelAndView("park/recordoutSide/parkRecordoutSide");
    }

    @RequiresPermissions(value={"park:recordoutSide:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkRecordoutSideService.getItemById(id));
        }
        return new ModelAndView("park/recordoutSide/editParkRecordoutSide");
    }

    @RequiresPermissions(value={"park:recordoutSide:edit"})
    public ZKResultMsg save(ParkRecordoutSideItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.parkRecordoutSideService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(ParkRecordoutSideItem codition) {
        Pager pager = this.parkRecordoutSideService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkRecordoutSideService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

