/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.auth.service.AuthSessionServcie;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.remote.ParkPersonRemote;
import com.zkteco.zkbiosecurity.park.service.ParkCarNumberService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.service.ParkPersonService;
import com.zkteco.zkbiosecurity.park.vo.ParkPersonItem;
import com.zkteco.zkbiosecurity.park.vo.ParkSelectPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkPersonController
extends BaseController
implements ParkPersonRemote {
    @Autowired
    private ParkPersonService parkPersonService;
    @Autowired
    private ParkCarNumberService parkCarNumberService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private AuthSessionServcie authSessionServcie;

    @RequiresPermissions(value={"park:person"})
    public ModelAndView index() {
        return new ModelAndView("park/person/parkPerson");
    }

    @RequiresPermissions(value={"pers:person:parkEdit"})
    public ModelAndView edit(@RequestParam(value="personId", required=false) String personId) {
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            List parkCarNumberItemList = this.parkCarNumberService.getByPersPersonId(personId);
            this.request.setAttribute("carNumberItems", (Object)parkCarNumberItemList);
        }
        this.request.setAttribute("parkDefaultPlate", (Object)this.parkParamsService.getDefaultPlate());
        this.request.setAttribute("personId", (Object)personId);
        return new ModelAndView("park/person/editParkPerson");
    }

    @RequiresPermissions(value={"pers:person:parkEdit"})
    public ZKResultMsg save(ParkPersonItem item) {
        this.parkPersonService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"park:person:refresh"})
    public DxGrid list(ParkPersonItem codition) {
        Pager pager = this.parkPersonService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:person:del"})
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.parkPersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid getSelectPersonlist(ParkSelectPersonItem codition) {
        Pager pager = this.parkPersonService.getSelectPersonlist(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public DxGrid getCarNumberSelectPersonlist(ParkSelectPersonItem codition) {
        SecuritySubject authUser = this.authSessionServcie.getSecuritySubject(this.request.getSession().getId());
        if (!authUser.getIsSuperuser().booleanValue() && authUser.getDepartmentIds() != null && authUser.getDepartmentIds().size() > 0) {
            codition.setDeptIdIn(authUser.getDepartmentIds().toString().replaceAll("[\\[\\]]", "").replaceAll(" ", ""));
        }
        Pager pager = this.parkPersonService.getCarNumberSelectPersonlist(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }
}

