/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.park.remote.ParkFinancialStatementsRemote;
import com.zkteco.zkbiosecurity.park.service.ParkFinancialStatementsService;
import com.zkteco.zkbiosecurity.park.vo.ParkFinancialStatementsItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkFinancialStatementsController
extends ExportController
implements ParkFinancialStatementsRemote {
    @Autowired
    private ParkFinancialStatementsService parkFinancialStatementsService;

    @RequiresPermissions(value={"park:financialStatements"})
    public ModelAndView index() {
        return new ModelAndView("park/financialStatements/parkFinancialStatements");
    }

    @RequiresPermissions(value={"park:financialStatements:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.parkFinancialStatementsService.getItemById(id));
        }
        return new ModelAndView("park/financialStatements/editParkFinancialStatements");
    }

    @RequiresPermissions(value={"park:financialStatements:edit"})
    @LogRequest(module="park_module", object="park_leftMenu_financialStatements", opType="park_changeShifts_reconciliation", requestParams={"authUserName"}, opContent="park_changeShifts_reconciliation")
    public ZKResultMsg save(ParkFinancialStatementsItem item) {
        this.parkFinancialStatementsService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid list(ParkFinancialStatementsItem codition) {
        Pager pager = this.parkFinancialStatementsService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkFinancialStatementsService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public void export(HttpServletRequest request, HttpServletResponse response) {
        List list = this.parkFinancialStatementsService.getByCondition(new ParkFinancialStatementsItem());
        this.excelExport(list, ParkFinancialStatementsItem.class);
    }
}

