/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.park.remote.ParkDailyReportRemote;
import com.zkteco.zkbiosecurity.park.service.ParkDailyReportService;
import com.zkteco.zkbiosecurity.park.vo.ParkDailyReportItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkDailyReportController
extends ExportController
implements ParkDailyReportRemote {
    @Autowired
    private ParkDailyReportService parkDailyReportService;

    @RequiresPermissions(value={"park:dailyReport"})
    public ModelAndView index() {
        return new ModelAndView("park/dailyReport/parkDailyReport");
    }

    public DxGrid list(ParkDailyReportItem codition) {
        Pager pager = this.parkDailyReportService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @LogRequest(module="park_module", object="park_leftMenu_dailyReport", opType="common_op_export", opContent="common_op_export")
    @RequiresPermissions(value={"park:dailyReport:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        ParkDailyReportItem parkDailyReportItem = new ParkDailyReportItem();
        this.setConditionValue((BaseItem)parkDailyReportItem);
        List itemList = this.parkDailyReportService.getItemData(parkDailyReportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, ParkDailyReportItem.class);
    }
}

