/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.service.AuthSessionServcie;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.park.remote.ParkCarNumberRemote;
import com.zkteco.zkbiosecurity.park.service.ParkCarNumberService;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.utils.ParkI18nUtil;
import com.zkteco.zkbiosecurity.park.vo.ParkCarNumberImportItem;
import com.zkteco.zkbiosecurity.park.vo.ParkCarNumberItem;
import com.zkteco.zkbiosecurity.park.vo.ParkCarNumberSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ParkCarNumberController
extends ExportController
implements ParkCarNumberRemote {
    @Autowired
    private ParkCarNumberService parkCarNumberService;
    @Autowired
    private ParkParamsService parkParamsService;
    @Autowired
    private AuthSessionServcie authSessionServcie;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"park:carNumber"})
    public ModelAndView index() {
        if ("lprCamera".equals(this.parkParamsService.getRunMode())) {
            this.request.setAttribute("showColumns", (Object)"!cardNo");
        }
        return new ModelAndView("park/carNumber/parkCarNumber");
    }

    @RequiresPermissions(value={"park:carNumber:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        this.request.setAttribute("item", (Object)this.parkCarNumberService.getItemById(id));
        return new ModelAndView("park/carNumber/editParkCarNumber");
    }

    @RequiresPermissions(value={"park:carNumber:edit"})
    @LogRequest(module="park_module", object="park_carNumber", opType="park_carNumber_edit", requestParams={"carNumber"}, opContent="park_carNumber")
    public ZKResultMsg save(ParkCarNumberItem item) {
        ZKResultMsg res = new ZKResultMsg();
        List parkDeviceResultList = this.parkCarNumberService.saveItem(item);
        res.setData(ParkI18nUtil.setI18nResultList(parkDeviceResultList));
        return res;
    }

    public DxGrid list(ParkCarNumberItem codition) {
        SecuritySubject authUser = this.authSessionServcie.getSecuritySubject(this.request.getSession().getId());
        if (!authUser.getIsSuperuser().booleanValue()) {
            if (authUser.getDepartmentIds() != null && authUser.getDepartmentIds().size() > 0) {
                codition.setDeptId(authUser.getDepartmentIds().toString().replaceAll("[\\[\\]]", "").replaceAll(" ", ""));
            } else {
                codition.setDeptId(null);
            }
        }
        Pager pager = this.parkCarNumberService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"park:carNumber:del"})
    @LogRequest(module="park_module", object="park_carNumber", opType="park_carNumber_del", requestParams={"names"}, opContent="park_carNumber_del")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.parkCarNumberService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getByPersPersonIdAndEditId(@RequestParam(value="persPersonId", required=false) String persPersonId, @RequestParam(value="carNumberId", required=false) String carNumberId) {
        List selectItems = this.parkCarNumberService.getByPersPersonIdAndEditId(persPersonId, carNumberId);
        return new ZKResultMsg((Object)selectItems);
    }

    public boolean isNotExist(@RequestParam(value="carNumber", required=false) String carNumber) {
        return this.parkCarNumberService.isNotExist(carNumber);
    }

    public boolean carNumberExistValid(@RequestParam(value="carNumber", required=false) String carNumber, @RequestParam(value="persPersonId", required=false) String persPersonId) {
        return this.parkCarNumberService.carNumberExistValid(carNumber, persPersonId);
    }

    public DxGrid getSelectList(ParkCarNumberSelectItem codition) {
        SecuritySubject authUser = this.authSessionServcie.getSecuritySubject(this.request.getSession().getId());
        if (!authUser.getIsSuperuser().booleanValue()) {
            if (authUser.getDepartmentIds() != null && authUser.getDepartmentIds().size() > 0) {
                codition.setDeptIdIn(authUser.getDepartmentIds().toString().replaceAll("[\\[\\]]", "").replaceAll(" ", ""));
            } else {
                codition.setDeptIdIn(null);
            }
        }
        Pager pager = this.parkCarNumberService.getSelectList(codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg getByPersonIdAndEditId(@RequestParam(value="persPersonId", required=false) String persPersonId, @RequestParam(value="carNumberId", required=false) String carNumberId) {
        List selectItems = this.parkCarNumberService.getByPersonIdAndEditId(persPersonId, carNumberId);
        return new ZKResultMsg((Object)selectItems);
    }

    public ZKResultMsg getByCardNoPersonIdAndEditCardNo(@RequestParam(value="persPersonId", required=false) String persPersonId, @RequestParam(value="cardNo", required=false) String cardNo) {
        List selectItems = this.parkCarNumberService.getByCardNoPersonIdAndEditCardNo(persPersonId, cardNo);
        return new ZKResultMsg((Object)selectItems);
    }

    @RequiresPermissions(value={"park:carNumber:exportTemp"})
    @LogRequest(module="park_module", object="park_carNumber", opType="park_carNumber_exportTemp", requestParams={}, opContent="park_carNumber_exportTemp")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonColumn = new JSONObject(true);
        jsonColumn.put("persPersonPin", (Object)I18nUtil.i18nCode((String)"pers_person_pin", (Object[])new Object[0]));
        jsonColumn.put("carNumbers", (Object)I18nUtil.i18nCode((String)"park_carNumber_importTip", (Object[])new Object[0]));
        HashMap jsonCloumnMap = new HashMap();
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("jsonColumn", jsonColumn.toJSONString());
        jsonCloumnMap.put("jsonColumn", jsonMap);
        ArrayList<ParkCarNumberImportItem> parkCarNumberImportItemList = new ArrayList<ParkCarNumberImportItem>();
        ParkCarNumberImportItem parkCarNumberImportItem = new ParkCarNumberImportItem();
        parkCarNumberImportItemList.add(parkCarNumberImportItem);
        this.excelExport(parkCarNumberImportItemList, ParkCarNumberImportItem.class, jsonCloumnMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"park:carNumber:import"})
    @LogRequest(module="park_module", object="park_carNumber", opType="park_carNumber_import", requestParams={}, opContent="park_carNumber_import")
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List list = this.excelImport(upload.getInputStream(), ParkCarNumberImportItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"park_carNumber_checkFile", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.parkCarNumberService.importExcel(list));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)e).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import ParkCarNumber Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }
}

