/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.api.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.park.api.vo.ParkApiRecordInItem;
import com.zkteco.zkbiosecurity.park.api.vo.ParkApiRecordOutItem;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordinSideItem;
import com.zkteco.zkbiosecurity.park.vo.ParkRecordoutItem;
import io.swagger.annotations.Api;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/parkTransaction"})
@Api(tags={"ParkTransaction"}, description="park transaction")
public class ParkApiTransactionController {
    private static final Logger log = LoggerFactory.getLogger(ParkApiTransactionController.class);
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;

    @ResponseBody
    @RequestMapping(value={"/listParkRecordin"}, method={RequestMethod.GET}, produces={"application/json"})
    public ApiResultMessage listParkRecordin(@RequestParam(name="carNumber", required=false) String carNumber, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        ApiResultMessage rs;
        try {
            rs = this.checkParams(pageNo, pageSize, startDate, endDate);
            if (Objects.nonNull(rs)) {
                return rs;
            }
            rs = new ApiResultMessage();
            ParkRecordinSideItem recordInSideItem = new ParkRecordinSideItem();
            if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
                Date startTime = DateUtil.stringToDate((String)startDate);
                Date endTime = DateUtil.stringToDate((String)endDate);
                recordInSideItem.setTimeBegin(startTime);
                recordInSideItem.setTimeEnd(endTime);
            }
            if (StringUtils.isNotBlank((CharSequence)carNumber)) {
                recordInSideItem.setCarNumber(carNumber);
            }
            ArrayList parkApiRecordInItemList = Lists.newArrayList();
            List parkRecordinSideItemList = this.parkRecordinService.getItemsByPage((BaseItem)recordInSideItem, pageNo - 1, pageSize.intValue()).getData();
            if (!parkRecordinSideItemList.isEmpty()) {
                parkRecordinSideItemList.forEach(parkRecordinSideItem -> {
                    ParkApiRecordInItem parkApiRecordInItem = ParkApiRecordInItem.createParkRecordIn((ParkRecordinSideItem)parkRecordinSideItem);
                    if (parkApiRecordInItem != null) {
                        parkApiRecordInItemList.add(parkApiRecordInItem);
                    }
                });
            }
            rs.setData((Object)parkApiRecordInItemList);
        }
        catch (Exception e) {
            log.error("parkTransaction/listParkRecordin error", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/listParkRecordout"}, method={RequestMethod.GET}, produces={"application/json"})
    public ApiResultMessage listParkRecordout(@RequestParam(name="carNumber", required=false) String carNumber, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        ApiResultMessage rs;
        try {
            rs = this.checkParams(pageNo, pageSize, startDate, endDate);
            if (Objects.nonNull(rs)) {
                return rs;
            }
            rs = new ApiResultMessage();
            ParkRecordoutItem recordOutItem = new ParkRecordoutItem();
            if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
                Date startTime = DateUtil.stringToDate((String)startDate);
                Date endTime = DateUtil.stringToDate((String)endDate);
                recordOutItem.setTimeBegin(startTime);
                recordOutItem.setTimeEnd(endTime);
            }
            if (StringUtils.isNotBlank((CharSequence)carNumber)) {
                recordOutItem.setCarNumber(carNumber);
            }
            List parkRecordoutList = this.parkRecordoutService.getItemsByPage((BaseItem)recordOutItem, pageNo - 1, pageSize.intValue()).getData();
            ArrayList parkApiRecordOutItemList = Lists.newArrayList();
            if (!parkRecordoutList.isEmpty()) {
                parkRecordoutList.forEach(parkRecordoutItem -> {
                    ParkApiRecordOutItem parkApiRecordOutItem = ParkApiRecordOutItem.createParkRecordout((ParkRecordoutItem)parkRecordoutItem);
                    if (parkApiRecordOutItem != null) {
                        parkApiRecordOutItemList.add(parkApiRecordOutItem);
                    }
                });
            }
            rs.setData((Object)parkApiRecordOutItemList);
        }
        catch (Exception e) {
            log.error("parkTransaction/listParkRecordout error", (Throwable)e);
            rs = new ApiResultMessage(-1, I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    private ApiResultMessage checkParams(Integer pageNo, Integer pageSize, String startDate, String endDate) {
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-91, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)startDate) || StringUtils.isNotBlank((CharSequence)endDate)) {
            Date startTime = DateUtil.stringToDate((String)startDate);
            Date endTime = DateUtil.stringToDate((String)endDate);
            if (startTime == null || endTime == null) {
                return ApiResultMessage.message((int)-222, (String)I18nUtil.i18nCode((String)"park_api_timeFormatOrEmpty", (Object[])new Object[0]));
            }
            if (startTime.getTime() > endTime.getTime()) {
                return ApiResultMessage.message((int)-228, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid4", (Object[])new Object[0]));
            }
        }
        return null;
    }
}

