/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.api.controller;

import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.park.bean.ParkProcessParameter;
import com.zkteco.zkbiosecurity.park.service.ParkChannelService;
import com.zkteco.zkbiosecurity.park.service.ParkDeviceService;
import com.zkteco.zkbiosecurity.park.service.ParkPavilioService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordinService;
import com.zkteco.zkbiosecurity.park.service.ParkRecordoutService;
import com.zkteco.zkbiosecurity.park.vo.ParkChannelItem;
import com.zkteco.zkbiosecurity.park.vo.ParkDeviceItem;
import com.zkteco.zkbiosecurity.park.vo.ParkPavilioItem;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/token/parkRecord"})
public class ParkApiRecordController {
    private static final Logger log = LoggerFactory.getLogger(ParkApiRecordController.class);
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkRecordinService parkRecordinService;
    @Autowired
    private ParkRecordoutService parkRecordoutService;
    @Autowired
    private ParkChannelService parkChannelService;
    @Autowired
    private ParkPavilioService parkPavilioService;

    @ResponseBody
    @RequestMapping(value={"/addRecordin"})
    public ApiResultMessage addRecordin(@RequestParam String carNumber, @RequestParam String deviceIp, @RequestParam String checkinTime) {
        ApiResultMessage rm = ApiResultMessage.successMessage();
        if (StringUtils.isBlank((CharSequence)deviceIp)) {
            rm.setCode(-1);
            rm.setMessage("\u53c2\u6570deviceIp\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rm;
        }
        ParkDeviceItem parkDeviceItem = this.parkDeviceService.getByIpAddress(deviceIp);
        if (parkDeviceItem == null) {
            rm.setCode(-1);
            rm.setMessage("\u8bbe\u5907IP\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u8bbe\u5907IP\u662f\u5426\u5b58\u5728\uff01");
            return rm;
        }
        if (StringUtils.isBlank((CharSequence)parkDeviceItem.getChannelId())) {
            rm.setCode(-1);
            rm.setMessage("\u8bbe\u5907\u672a\u7ed1\u5b9a\u901a\u9053\uff0c\u8bf7\u5148\u7ed1\u5b9a\u901a\u9053\uff01");
            return rm;
        }
        ParkProcessParameter parameter = new ParkProcessParameter();
        parameter.setLicense(carNumber);
        parameter.setDevice(parkDeviceItem);
        ParkChannelItem parkChannelItem = this.parkChannelService.getItemById(parkDeviceItem.getChannelId());
        parameter.setParkChannelId(parkChannelItem.getId());
        ParkPavilioItem parkPavilioItem = this.parkPavilioService.getItemById(parkChannelItem.getPavilioId());
        parameter.setPavilioIP(parkPavilioItem.getIpAddress());
        String photoPath = this.parkRecordinService.snapImage(parkDeviceItem.getIpAddress(), carNumber);
        parameter.setPhotoPath(photoPath);
        Timestamp inTime = DateUtil.getCurrentTime();
        if (StringUtils.isNotBlank((CharSequence)checkinTime)) {
            inTime = Timestamp.valueOf(checkinTime);
        }
        parameter.setCheckinTime(inTime);
        parameter.setManual(true);
        parameter.setConfirmFlag(true);
        this.parkRecordinService.tempCarProcessTest(parameter);
        return rm;
    }

    @ResponseBody
    @RequestMapping(value={"/addRecordout"})
    public ApiResultMessage addRecordout(@RequestParam String carNumber, @RequestParam String deviceIp, @RequestParam String checkoutTime) {
        ApiResultMessage rm = ApiResultMessage.successMessage();
        if (StringUtils.isBlank((CharSequence)deviceIp)) {
            rm.setCode(-1);
            rm.setMessage("\u53c2\u6570deviceIp\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rm;
        }
        ParkDeviceItem parkDeviceItem = this.parkDeviceService.getByIpAddress(deviceIp);
        if (parkDeviceItem == null) {
            rm.setCode(-1);
            rm.setMessage("\u8bbe\u5907IP\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u8bbe\u5907IP\u662f\u5426\u5b58\u5728\uff01");
            return rm;
        }
        if (StringUtils.isBlank((CharSequence)parkDeviceItem.getChannelId())) {
            rm.setCode(-1);
            rm.setMessage("\u8bbe\u5907\u672a\u7ed1\u5b9a\u901a\u9053\uff0c\u8bf7\u5148\u7ed1\u5b9a\u901a\u9053\uff01");
            return rm;
        }
        ParkProcessParameter parameter = new ParkProcessParameter();
        parameter.setLicense(carNumber);
        parameter.setDevice(parkDeviceItem);
        ParkChannelItem parkChannelItem = this.parkChannelService.getItemById(parkDeviceItem.getChannelId());
        parameter.setParkChannelId(parkChannelItem.getId());
        ParkPavilioItem parkPavilioItem = this.parkPavilioService.getItemById(parkChannelItem.getPavilioId());
        parameter.setPavilioIP(parkPavilioItem.getIpAddress());
        String photoPath = this.parkRecordinService.snapImage(parkDeviceItem.getIpAddress(), carNumber);
        parameter.setPhotoPath(photoPath);
        Timestamp outTime = DateUtil.getCurrentTime();
        if (StringUtils.isNotBlank((CharSequence)checkoutTime)) {
            outTime = Timestamp.valueOf(checkoutTime);
        }
        parameter.setCheckoutTime(outTime);
        parameter.setManual(true);
        parameter.setConfirmFlag(true);
        this.parkRecordoutService.tempCarProcess(parkChannelItem, false, parameter, null);
        return rm;
    }
}

