/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisDeviceRemote;
import com.zkteco.zkbiosecurity.sis.service.SisAuthDeviceService;
import com.zkteco.zkbiosecurity.sis.service.SisDevCmdService;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceParamsService;
import com.zkteco.zkbiosecurity.sis.service.SisDeviceService;
import com.zkteco.zkbiosecurity.sis.vo.SisAuthDeviceItem;
import com.zkteco.zkbiosecurity.sis.vo.SisDeviceItem;
import com.zkteco.zkbiosecurity.sis.vo.SisDeviceParamsItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisDeviceController
extends ExportController
implements SisDeviceRemote {
    @Autowired
    private SisDeviceService sisDeviceService;
    @Autowired
    private SisAuthDeviceService sisAuthDeviceService;
    @Autowired
    private SisDevCmdService sisDevCmdService;
    @Autowired
    private SisDeviceParamsService sisDeviceParamsService;

    @RequiresPermissions(value={"sis:device"})
    public ModelAndView index() {
        return new ModelAndView("sis/device/sisDevice");
    }

    @RequiresPermissions(value={"sis:device:edit"})
    public ModelAndView edit(String id, String ipAddress, String devSn, String rowId, String model) {
        SisDeviceItem sisDeviceItem = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            sisDeviceItem = this.sisDeviceService.findById(id);
        } else {
            sisDeviceItem = new SisDeviceItem();
            sisDeviceItem.setSn(devSn);
            sisDeviceItem.setIp(ipAddress);
            sisDeviceItem.setModel(model);
        }
        this.request.setAttribute("item", (Object)sisDeviceItem);
        this.request.setAttribute("rowId", (Object)rowId);
        this.request.setAttribute("editPage", (Object)"true");
        return new ModelAndView("sis/device/addSisDevice");
    }

    @RequiresPermissions(value={"sis:device:save"})
    @LogRequest(module="sis_module", object="common_leftMenu_device", opType="common_op_edit", requestParams={"name"}, opContent="common_dev_name")
    public ZKResultMsg save(SisDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        item.setState(Boolean.valueOf(true));
        this.sisDeviceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"sis:device:refresh"})
    public DxGrid list(SisDeviceItem condition) {
        Pager pager = this.sisDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        List sisDeviceItems = pager.getData();
        for (SisDeviceItem sisDeviceItem : sisDeviceItems) {
            sisDeviceItem.setOnlineStatus(Boolean.valueOf(this.sisDeviceService.checkOnlineStatus(sisDeviceItem)));
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"sis:device:del"})
    @LogRequest(module="sis_module", object="common_leftMenu_device", opType="common_op_del", requestParams={"name"}, opContent="common_dev_name")
    public ZKResultMsg del(String ids) {
        this.sisDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"sis:device:search"})
    public ModelAndView getSearchDevInfo() {
        return new ModelAndView("sis/device/opSisSearchDev");
    }

    public ZKResultMsg getAllIPSn() {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.sisDeviceService.getAllIPSn()));
    }

    @RequiresPermissions(value={"ins:device:search"})
    public ZKResultMsg searchDev(Long nowTime) {
        HashMap<String, Object> devInfo = new HashMap<String, Object>(16);
        List devcieItems = this.sisAuthDeviceService.getByCondition(new SisAuthDeviceItem());
        devcieItems = this.sisAuthDeviceService.filterOnlineDev(devcieItems);
        devInfo.put("devCount", devcieItems.size());
        devInfo.put("devData", devcieItems);
        devInfo.put("nowTime", nowTime);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg(devInfo));
    }

    public boolean isExistName(@RequestParam(value="name") String name) {
        return this.sisDeviceService.isExistName(name);
    }

    @RequiresPermissions(value={"sis:device:enable"})
    public ZKResultMsg enable(String ids) {
        ZKResultMsg msg = this.sisDeviceService.enable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)msg);
    }

    public ZKResultMsg disable(String ids) {
        ZKResultMsg msg = this.sisDeviceService.disable(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)msg);
    }

    public ZKResultMsg checkGateDevice(String id) {
        ZKResultMsg ret = new ZKResultMsg();
        SisDeviceItem item = this.sisDeviceService.findById(id);
        if (this.sisDeviceService.checkOnlineStatus(item) && item.getState().booleanValue()) {
            if (item == null || !item.getModel().equals("4330") && !item.getModel().equals("3180")) {
                ret.setRet("faild");
                ret.setMsg(I18nUtil.i18nCode((String)"sis_gateOperate_selectGateDev", (Object[])new Object[0]));
            }
        } else {
            ret.setRet("faild");
            ret.setMsg(I18nUtil.i18nCode((String)"sis_dev_offLineOrDisable", (Object[])new Object[0]));
        }
        return ret;
    }

    public ModelAndView setParams(String id) {
        SisDeviceParamsItem deviceParamsItem = this.sisDeviceParamsService.findById(id);
        this.request.setAttribute("item", (Object)deviceParamsItem);
        this.request.setAttribute("editPage", (Object)"true");
        return new ModelAndView("sis/device/setSisDeviceParams");
    }

    public ZKResultMsg getParams(String ids) {
        ZKResultMsg ret = new ZKResultMsg();
        for (String id : ids.split(",")) {
            SisDeviceItem deviceItem = this.sisDeviceService.findById(id);
            if (this.sisDeviceService.checkOnlineStatus(deviceItem) && deviceItem.getState().booleanValue()) {
                if (deviceItem.getModel().equals("4330") || deviceItem.getModel().equals("3180")) {
                    this.sisDevCmdService.getSystemParams(deviceItem);
                    this.sisDevCmdService.getZoneSencitivity(deviceItem);
                    this.sisDevCmdService.getModelVersion(deviceItem);
                    continue;
                }
                ret.setRet("faild");
                ret.setMsg(I18nUtil.i18nCode((String)"sis_gateOperate_selectGateDev", (Object[])new Object[0]));
                continue;
            }
            ret.setRet("faild");
            ret.setMsg(I18nUtil.i18nCode((String)"sis_dev_offLineOrDisable", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ModelAndView syncTimeView(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        this.request.setAttribute("dateTime", (Object)DateUtil.dateToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        return new ModelAndView("sis/device/syncTime");
    }

    public ZKResultMsg syncTime(String ids) {
        String dateTime = this.request.getParameter("systemTime");
        String password = this.request.getParameter("password");
        SisDeviceItem condition = new SisDeviceItem();
        condition.setInId(ids);
        List devList = this.sisDeviceService.getByCondition(condition);
        for (SisDeviceItem dev : devList) {
            this.sisDevCmdService.setSystemTime(dev, dateTime, password);
        }
        ZKResultMsg ret = new ZKResultMsg();
        ret.setMsg("sis_gateOperate_cmdSendSuccess");
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ModelAndView updateCommPwd(String id) {
        this.request.setAttribute("id", (Object)id);
        return new ModelAndView("sis/device/updateCommPwd");
    }

    public ZKResultMsg setPwd(String id) {
        String newPwd = this.request.getParameter("newPwd");
        String oldPwd = this.request.getParameter("oldPwd");
        SisDeviceItem dev = this.sisDeviceService.findById(id);
        this.sisDevCmdService.setSystemPassword(dev, newPwd, oldPwd);
        ZKResultMsg ret = new ZKResultMsg();
        ret.setMsg("sis_gateOperate_cmdSendSuccess");
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg enableSync(String id) {
        SisDeviceItem dev = this.sisDeviceService.findById(id);
        this.sisDevCmdService.setEnableSync(dev);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg stopSync(String id) {
        SisDeviceItem dev = this.sisDeviceService.findById(id);
        this.sisDevCmdService.stopEnableSync(dev);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg saveDevParams(SisDeviceParamsItem item) {
        item.setSencitivityLevel(Integer.valueOf(0));
        item.setDisplayMode(Integer.valueOf(0));
        this.sisDeviceParamsService.saveItem(item);
        String password = this.request.getParameter("password");
        SisDeviceItem device = this.sisDeviceService.findById(item.getSisDeviceId());
        ArrayList<Integer> param = new ArrayList<Integer>();
        param.add(item.getSencitivityLevel());
        param.add(item.getShockSensitivity());
        param.add(item.getAudibleAlarmTime());
        param.add(item.getLedAlarmTime());
        param.add(item.getAlarmVolume());
        param.add(item.getLedAlarmTone());
        param.add(item.getSystemDefenseZone());
        param.add(item.getLanguage());
        param.add(item.getPowerOn());
        param.add(item.getWorkChannel());
        param.add(item.getWorkSpeed());
        param.add(item.getDisplayMode());
        param.add(item.getLedBacklight());
        param.add(item.getOverallSensitivity());
        param.add(item.getZoneSencitivity1());
        param.add(item.getZoneSencitivity2());
        param.add(item.getZoneSencitivity3());
        param.add(item.getZoneSencitivity4());
        param.add(item.getZoneSencitivity5());
        param.add(item.getZoneSencitivity6());
        param.add(item.getZoneSencitivity7());
        param.add(item.getZoneSencitivity8());
        param.add(item.getZoneSencitivity9());
        param.add(item.getZoneSencitivity10());
        param.add(item.getZoneSencitivity11());
        param.add(item.getZoneSencitivity12());
        this.sisDevCmdService.setSystemParameters(device, password, param);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg("ok", I18nUtil.i18nCode((String)"sis_gateOperate_cmdSendSuccess", (Object[])new Object[0])));
    }

    public ModelAndView setAD(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        return new ModelAndView("sis/device/setAD");
    }

    public ZKResultMsg setADToDev(String ids, String adContent) {
        ZKResultMsg ret = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)adContent)) {
            this.sisDeviceService.setADToDev(ids, adContent);
        } else {
            ret.setRet("faild");
            ret.setMsg(I18nUtil.i18nCode((String)"sis_ad_isEmpty", (Object[])new Object[0]));
        }
        return ret;
    }

    public ZKResultMsg delAD(String ids) {
        this.sisDeviceService.delADToDev(ids);
        return new ZKResultMsg();
    }

    public ModelAndView setTipStrategy(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        return new ModelAndView("sis/device/setTipStrategy");
    }

    public ZKResultMsg setTipStrategyToDev(String ids) {
        String tipStrategyId = this.request.getParameter("tipStrategy");
        this.sisDeviceService.setTipStrategyToDev(ids, tipStrategyId);
        return new ZKResultMsg();
    }

    public ZKResultMsg delTipStrategy(String ids) {
        this.sisDeviceService.delTipStrategy(ids);
        return new ZKResultMsg();
    }

    public ZKResultMsg delAllTip(String ids) {
        this.sisDeviceService.delAllTip(ids);
        return new ZKResultMsg();
    }

    public ModelAndView uploadTransaction(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        return new ModelAndView("sis/device/uploadTransaction");
    }

    public ZKResultMsg uploadTransactionFromDev(String ids) {
        String[] transType = this.request.getParameterValues("transType");
        String startTime = this.request.getParameter("startTime");
        String endTime = this.request.getParameter("endTime");
        for (String type : transType) {
            this.sisDeviceService.uploadTransactionFromDev(ids, type, startTime, endTime);
        }
        return new ZKResultMsg();
    }

    public ZKResultMsg checkDevDevice(String id) {
        ZKResultMsg ret = new ZKResultMsg();
        SisDeviceItem item = this.sisDeviceService.findById(id);
        if (this.sisDeviceService.checkOnlineStatus(item) && item.getState().booleanValue()) {
            if (item == null || !item.getType().equals("5030")) {
                ret.setRet("faild");
                ret.setMsg(I18nUtil.i18nCode((String)"sis_gateOperate_selectDev", (Object[])new Object[0]));
            }
        } else {
            ret.setRet("faild");
            ret.setMsg(I18nUtil.i18nCode((String)"sis_dev_offLineOrDisable", (Object[])new Object[0]));
        }
        return ret;
    }

    public ZKResultMsg getDevStateData() {
        ZKResultMsg resultMsg = new ZKResultMsg();
        List devList = this.sisDeviceService.getItemByType("5030");
        JSONObject obj = this.sisDeviceService.getDeviceStatusData(devList);
        List gateList = this.sisDeviceService.getItemByType("4330");
        List gateList3180 = this.sisDeviceService.getItemByType("3180");
        gateList.addAll(gateList3180);
        JSONObject gateObj = this.sisDeviceService.getGateStatusData(gateList);
        obj.put("gate", (Object)gateObj);
        resultMsg.setData((Object)obj);
        return resultMsg;
    }

    public ZKResultMsg getVidDevStateData() {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject obj = this.sisDeviceService.getVidDevStateData();
        resultMsg.setData((Object)obj);
        return resultMsg;
    }

    public ZKResultMsg getDevAllData() {
        ZKResultMsg resultMsg = new ZKResultMsg();
        List devList = this.sisDeviceService.getItemByType("5030");
        List gateList = this.sisDeviceService.getItemByType("4330");
        List gateList3180 = this.sisDeviceService.getItemByType("3180");
        gateList.addAll(gateList3180);
        JSONObject obj = this.sisDeviceService.getDevAllData(devList, gateList);
        resultMsg.setData((Object)obj);
        return resultMsg;
    }

    public ZKResultMsg getMapDevAllData(String areaName) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject obj = this.sisDeviceService.getMapDevAllData(areaName);
        resultMsg.setData((Object)obj);
        return resultMsg;
    }
}

