/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import jdk.internal.misc.CDS;
import jdk.internal.vm.annotation.Stable;

public final class Short
extends Number
implements Comparable<Short> {
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class<Short> TYPE = Class.getPrimitiveClass("short");
    private final short value;
    public static final int SIZE = 16;
    private static final long serialVersionUID = 7515723908773894738L;

    public static String toString(short s) {
        return Integer.toString(s, 10);
    }

    public static short parseShort(String string, int n) throws NumberFormatException {
        int n2 = Integer.parseInt(string, n);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new NumberFormatException("Value out of range. Value:\"" + string + "\" Radix:" + n);
        }
        return (short)n2;
    }

    public static short parseShort(String string) throws NumberFormatException {
        return Short.parseShort(string, 10);
    }

    public static Short valueOf(String string, int n) throws NumberFormatException {
        return Short.parseShort(string, n);
    }

    public static Short valueOf(String string) throws NumberFormatException {
        return Short.valueOf(string, 10);
    }

    public static Short valueOf(short s) {
        short s2 = s;
        if (s2 >= -128 && s2 <= 127) {
            return ShortCache.cache[s2 + 128];
        }
        return new Short(s);
    }

    public static Short decode(String string) throws NumberFormatException {
        int n = Integer.decode(string);
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new NumberFormatException("Value " + n + " out of range from input " + string);
        }
        return (short)n;
    }

    public Short(short s) {
        this.value = s;
    }

    public Short(String string) throws NumberFormatException {
        this.value = Short.parseShort(string, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Short) {
            return this.value == (Short)object;
        }
        return false;
    }

    @Override
    public int compareTo(Short s) {
        return Short.compare(this.value, s.value);
    }

    public static int compare(short s, short s2) {
        return s - s2;
    }

    public static short reverseBytes(short s) {
        return (short)((s & 0xFF00) >> 8 | s << 8);
    }

    private static final class ShortCache {
        @Stable
        static final Short[] cache;
        static Short[] archivedCache;

        private ShortCache() {
        }

        static {
            int size = 256;
            CDS.initializeFromArchive(ShortCache.class);
            if (archivedCache == null || archivedCache.length != size) {
                Short[] c = new Short[size];
                short value = -128;
                for (int i = 0; i < size; ++i) {
                    short s = value;
                    value = (short)(value + 1);
                    c[i] = new Short(s);
                }
                archivedCache = c;
            }
            cache = archivedCache;
        }
    }
}

