/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.workflow.init;

import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=330)
public class WorkflowInit
implements CommandLineRunner {
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private AuthPermissionService authPermissionService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("WorkflowInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.baseSysParamService.setAlreadyInitModule("WorkflowInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemMenuItem = null;
        AuthPermissionItem parentMenuItem = null;
        AuthPermissionItem childMenuItem = null;
        AuthPermissionItem buttonMenuItem = null;
        systemMenuItem = this.authPermissionService.getItemByCode("Att");
        if (Objects.isNull(systemMenuItem)) {
            return;
        }
        parentMenuItem = new AuthPermissionItem("WfFlowable", "wf_leftMenu_flow", "wf:task", "menu", "true", Integer.valueOf(11));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setImg("wf_flow.png");
        parentMenuItem.setImgHover("wf_flow_over.png");
        parentMenuItem.setActionLink("attWorkflow.do?myApply");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("WFFlowableMyApply", "wf_leftMenu_flowable_myapply", "wf:myApply:list", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attFlowable.do?myApply");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        childMenuItem = new AuthPermissionItem("WfFlowablePendingTask", "wf_leftMenu_flowable", "wf:pendingTask:list", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attFlowable.do?pendingTask");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        childMenuItem = new AuthPermissionItem("WfFlowableApprovedTask", "wf_leftMenu_flowable_his", "wf:approvedTask:list", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attFlowable.do?approvedTask");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        parentMenuItem = this.authPermissionService.getItemByCode("AttBasicInformation");
        if (Objects.nonNull(parentMenuItem)) {
            childMenuItem = new AuthPermissionItem("WfFlowableList", "wf_leftMenu_flow_setting", "wf:flow", "menu", "true", Integer.valueOf(6));
            childMenuItem.setParentId(parentMenuItem.getId());
            childMenuItem.setActionLink("/wfFlow.do?moduleCode=att");
            childMenuItem = this.authPermissionService.saveItem(childMenuItem);
            buttonMenuItem = new AuthPermissionItem("WfFlowItemRefresh", "common_op_refresh", "wf:flow:refresh", "button", "true", Integer.valueOf(1));
            buttonMenuItem.setParentId(childMenuItem.getId());
            this.authPermissionService.saveItem(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("WfFlowItemAdd", "common_op_add", "wf:flow:add", "button", "true", Integer.valueOf(2));
            buttonMenuItem.setParentId(childMenuItem.getId());
            this.authPermissionService.saveItem(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("WfFlowItemEdit", "common_op_edit", "wf:flow:edit", "button", "true", Integer.valueOf(3));
            buttonMenuItem.setParentId(childMenuItem.getId());
            this.authPermissionService.saveItem(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("WfFlowItemDel", "common_op_del", "wf:flow:del", "button", "true", Integer.valueOf(4));
            buttonMenuItem.setParentId(childMenuItem.getId());
            this.authPermissionService.saveItem(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("WfFlowItemEnable", "common_enable", "wf:flow:enable", "button", "true", Integer.valueOf(5));
            buttonMenuItem.setParentId(childMenuItem.getId());
            this.authPermissionService.saveItem(buttonMenuItem);
            buttonMenuItem = new AuthPermissionItem("WfFlowItemDisable", "common_commStatus_disable", "wf:flow:disable", "button", "true", Integer.valueOf(6));
            buttonMenuItem.setParentId(childMenuItem.getId());
            this.authPermissionService.saveItem(buttonMenuItem);
        }
    }
}

