/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GroupBy;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.UUID;

@From(after="POSID_TRANSACTION T")
@GroupBy(after="T.person_pin, T.person_name,T.person_last_name")
@OrderBy(after="t.person_pin ASC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDPersonConsumeItem
extends BaseItem {
    @GridColumn(show=false)
    private String id;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100", i18n=true)
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="80", i18n=true)
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="sum(case when t.type_name = 6  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_conTimes", width="120")
    private Integer conTimes;
    @Column(name="sum(case when t.type_name = 8  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_suppleTotal", width="160", columnType="custom", convert="convertFen2Yuan")
    private Integer suppletotal;
    @Column(name="sum(case when t.type_name = 6  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_consumTotal", width="115", columnType="custom", convert="convertFen2Yuan")
    private Integer consumtotal;
    @Column(name="sum(case when t.type_name = 6  then t.discount_money  else 0 end)")
    @GridColumn(label="posid_consume_discount_money_sum", width="115", columnType="custom", convert="convertFen2Yuan")
    private Integer discountMoney;
    @Column(name="sum(case when t.type_name = 9  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_errorTimes", width="170")
    private Integer errortimes;
    @Column(name="sum(case when t.type_name = 8  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_suppleTimes", width="200")
    private Integer suppletimes;
    @Column(name="sum(case when t.type_name = 9  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_errorTotal", width="80", columnType="custom", convert="convertFen2Yuan")
    private Integer errortotal;
    @Column(name="sum(case when t.type_name = 10 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_orderTimes", width="70")
    private Integer ordertimes;
    @Column(name="sum(case when t.type_name = 11  then 1 else 0 end)")
    @GridColumn(label="posid_countTable_accountTimes", width="70", show=false)
    private Integer accounttimes;
    @Column(name="sum(case when t.type_name = 11  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_accountTotal", width="80", columnType="custom", convert="convertFen2Yuan", show=false)
    private Integer accountTotal;
    @Column(name="sum(case when t.type_name = 6 then 1 else 0 end)")
    @GridColumn(label="posid_countTable_actualTimes", width="110")
    private Integer actualtimes;
    @Column(name="sum(case when t.type_name = 6  then t.money else 0 end)")
    @GridColumn(label="posid_countTable_equipTotal", width="110", columnType="custom", convert="convertFen2Yuan")
    private Integer equipTotal;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money else 0 end)+sum(case when t.type_name = 8  then t.money else 0 end)) as decimal(18,2))")
    @GridColumn(label="posid_countTable_sysTotal", width="135", columnType="custom", convert="convertFen2Yuan")
    private Integer sysTotal;
    @Column(name="cast((sum(case when t.type_name = 6  then t.money else 0 end)+sum(case when t.type_name = 11  then t.money else 0 end)) as decimal(18,2))")
    @GridColumn(label="posid_countTable_containAccTotal", width="135", columnType="custom", convert="convertFen2Yuan")
    private Integer containAccTotal;
    @GridColumn(label="posid_countTable_conTimeStr", minWidth="160", width="170", sort="na")
    private String posTime;
    @Condition(value="t.POS_TIME", equalTag=">=", toDate=true)
    private String opTimeBegin;
    @Condition(value="t.POS_TIME", equalTag="<=", toDate=true)
    private String opTimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.DEV_SN", equalTag="=")
    private String devSn;
    @Condition(value="t.PERSON_PIN", equalTag="=")
    private String eqlPersonPin;

    public PosIDPersonConsumeItem() {
        this.id = UUID.randomUUID().toString();
    }

    public PosIDPersonConsumeItem(Boolean equals) {
        super(equals);
    }

    public PosIDPersonConsumeItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosIDPersonConsumeItem(Boolean equals, String id, String personPin, String personName, String personLastName, Integer conTimes, Integer suppletotal, Integer consumtotal, Integer errortimes, Integer suppletimes, Integer errortotal, Integer ordertimes, Integer accounttimes, Integer accountTotal, Integer actualtimes, Integer equipTotal, Integer sysTotal, Integer containAccTotal) {
        this.id = id;
        this.personPin = personPin;
        this.personName = personName;
        this.personLastName = personLastName;
        this.conTimes = conTimes;
        this.suppletotal = suppletotal;
        this.consumtotal = consumtotal;
        this.errortimes = errortimes;
        this.suppletimes = suppletimes;
        this.errortotal = errortotal;
        this.ordertimes = ordertimes;
        this.accounttimes = accounttimes;
        this.accountTotal = accountTotal;
        this.actualtimes = actualtimes;
        this.equipTotal = equipTotal;
        this.sysTotal = sysTotal;
        this.containAccTotal = containAccTotal;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public Integer getConTimes() {
        return this.conTimes;
    }

    public Integer getSuppletotal() {
        return this.suppletotal;
    }

    public Integer getConsumtotal() {
        return this.consumtotal;
    }

    public Integer getDiscountMoney() {
        return this.discountMoney;
    }

    public Integer getErrortimes() {
        return this.errortimes;
    }

    public Integer getSuppletimes() {
        return this.suppletimes;
    }

    public Integer getErrortotal() {
        return this.errortotal;
    }

    public Integer getOrdertimes() {
        return this.ordertimes;
    }

    public Integer getAccounttimes() {
        return this.accounttimes;
    }

    public Integer getAccountTotal() {
        return this.accountTotal;
    }

    public Integer getActualtimes() {
        return this.actualtimes;
    }

    public Integer getEquipTotal() {
        return this.equipTotal;
    }

    public Integer getSysTotal() {
        return this.sysTotal;
    }

    public Integer getContainAccTotal() {
        return this.containAccTotal;
    }

    public String getPosTime() {
        return this.posTime;
    }

    public String getOpTimeBegin() {
        return this.opTimeBegin;
    }

    public String getOpTimeEnd() {
        return this.opTimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public String getEqlPersonPin() {
        return this.eqlPersonPin;
    }

    public PosIDPersonConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDPersonConsumeItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDPersonConsumeItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDPersonConsumeItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDPersonConsumeItem setConTimes(Integer conTimes) {
        this.conTimes = conTimes;
        return this;
    }

    public PosIDPersonConsumeItem setSuppletotal(Integer suppletotal) {
        this.suppletotal = suppletotal;
        return this;
    }

    public PosIDPersonConsumeItem setConsumtotal(Integer consumtotal) {
        this.consumtotal = consumtotal;
        return this;
    }

    public PosIDPersonConsumeItem setDiscountMoney(Integer discountMoney) {
        this.discountMoney = discountMoney;
        return this;
    }

    public PosIDPersonConsumeItem setErrortimes(Integer errortimes) {
        this.errortimes = errortimes;
        return this;
    }

    public PosIDPersonConsumeItem setSuppletimes(Integer suppletimes) {
        this.suppletimes = suppletimes;
        return this;
    }

    public PosIDPersonConsumeItem setErrortotal(Integer errortotal) {
        this.errortotal = errortotal;
        return this;
    }

    public PosIDPersonConsumeItem setOrdertimes(Integer ordertimes) {
        this.ordertimes = ordertimes;
        return this;
    }

    public PosIDPersonConsumeItem setAccounttimes(Integer accounttimes) {
        this.accounttimes = accounttimes;
        return this;
    }

    public PosIDPersonConsumeItem setAccountTotal(Integer accountTotal) {
        this.accountTotal = accountTotal;
        return this;
    }

    public PosIDPersonConsumeItem setActualtimes(Integer actualtimes) {
        this.actualtimes = actualtimes;
        return this;
    }

    public PosIDPersonConsumeItem setEquipTotal(Integer equipTotal) {
        this.equipTotal = equipTotal;
        return this;
    }

    public PosIDPersonConsumeItem setSysTotal(Integer sysTotal) {
        this.sysTotal = sysTotal;
        return this;
    }

    public PosIDPersonConsumeItem setContainAccTotal(Integer containAccTotal) {
        this.containAccTotal = containAccTotal;
        return this;
    }

    public PosIDPersonConsumeItem setPosTime(String posTime) {
        this.posTime = posTime;
        return this;
    }

    public PosIDPersonConsumeItem setOpTimeBegin(String opTimeBegin) {
        this.opTimeBegin = opTimeBegin;
        return this;
    }

    public PosIDPersonConsumeItem setOpTimeEnd(String opTimeEnd) {
        this.opTimeEnd = opTimeEnd;
        return this;
    }

    public PosIDPersonConsumeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDPersonConsumeItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public PosIDPersonConsumeItem setDevSn(String devSn) {
        this.devSn = devSn;
        return this;
    }

    public PosIDPersonConsumeItem setEqlPersonPin(String eqlPersonPin) {
        this.eqlPersonPin = eqlPersonPin;
        return this;
    }

    public String toString() {
        return "PosIDPersonConsumeItem(id=" + this.getId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", conTimes=" + this.getConTimes() + ", suppletotal=" + this.getSuppletotal() + ", consumtotal=" + this.getConsumtotal() + ", discountMoney=" + this.getDiscountMoney() + ", errortimes=" + this.getErrortimes() + ", suppletimes=" + this.getSuppletimes() + ", errortotal=" + this.getErrortotal() + ", ordertimes=" + this.getOrdertimes() + ", accounttimes=" + this.getAccounttimes() + ", accountTotal=" + this.getAccountTotal() + ", actualtimes=" + this.getActualtimes() + ", equipTotal=" + this.getEquipTotal() + ", sysTotal=" + this.getSysTotal() + ", containAccTotal=" + this.getContainAccTotal() + ", posTime=" + this.getPosTime() + ", opTimeBegin=" + this.getOpTimeBegin() + ", opTimeEnd=" + this.getOpTimeEnd() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ", devSn=" + this.getDevSn() + ", eqlPersonPin=" + this.getEqlPersonPin() + ")";
    }
}

