/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POSID_ACCOUNT t LEFT JOIN POSID_ACCOUNTKIND P ON P.ID=t.ACCOUNTKIND_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosIDAccountExportItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100")
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="t.ACCOUNT_NO")
    @GridColumn(label="posid_card_accountNum", width="120")
    private String accountNo;
    @Column(name="t.STATUS")
    @GridColumn(label="posid_account_type", width="90", format="1=posid_card_changeOperator,0=posid_account_type_comomon")
    private Integer status;
    @Column(name="P.NAME")
    @GridColumn(label="posid_leftMenu_icCard", width="120", show=false)
    private String name;
    @Column(name="t.BALANCE")
    @GridColumn(label="posid_card_blance", width="120", columnType="custom")
    private Double balance;
    @GridColumn(show=true, label="posid_account_money_wallet", columnType="custom")
    private Double posMoneyWallet;
    @GridColumn(show=true, label="posid_account_allowance_wallet", columnType="custom")
    private Double posAllowanceWallet;
    @GridColumn(label="posid_card_deptNum", width="120")
    private String deptCode;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="posid_card_deptName", width="110")
    private String deptName;
    @Column(name="t.ACCOUNT_TYPE")
    @GridColumn(label="posid_leftMenu_icCard", width="110", format="0=posid_account_type_pers", show=false)
    private Integer accountType;
    @Column(name="t.ISSUE_DATE")
    @GridColumn(label="posid_card_sendCardDate", width="240")
    private Date issueDate;
    @Column(name="t.PASSWORD")
    @GridColumn(label="posid_cardManage_password", show=false)
    private String password;
    @Column(name="t.SERIAL_NUM")
    @GridColumn(label="posid_cardManage_cardSerialNum", show=false)
    private Integer serialNum;
    @Column(name="t.IS_VALID")
    @GridColumn(label="posid_card_isValid", format="0=common_enable,1=common_disable,")
    private Integer available;
    @Column(name="t.ACCOUNT_MEMBER")
    @GridColumn(label="posid_account_member", width="100", format="0=posid_card_false,1=posid_card_true")
    private Integer accountMember;
    @Column(name="t.POS_DATE")
    @GridColumn(label="posid_cardManage_posDate", show=false)
    private Date posDate;
    @Column(name="t.DEPT_ID")
    @GridColumn(label="posid_cardManage_deptId", show=false)
    private String deptId;
    @Column(name="t.PERSON_ID")
    @GridColumn(label="posid_cardManage_personId", show=false)
    private String personId;
    @Column(name="t.ACCOUNTKIND_ID")
    @GridColumn(label="posid_cardManage_posCardKind", show=false)
    private String posAccountKindId;
    @Column(name="p.name")
    @GridColumn(label="posid_card_cardName", width="120")
    private String accountKindName;
    @Condition(value="t.ID", equalTag="not in")
    private String notInId;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(t.PERSON_NAME LIKE ''%{0}%'' OR t.PERSON_LAST_NAME LIKE ''%{0}%'')")
    private String likeName;

    public PosIDAccountExportItem() {
    }

    public PosIDAccountExportItem(Boolean equals) {
        super(equals);
    }

    public PosIDAccountExportItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosIDAccountExportItem(String id, String personId, String personPin, String personName, String personLastName, String deptId, String deptCode, String deptName, String accountNo, Double balance, String password, Integer serialNum, Date issueDate, Integer isValid, Integer status, Date posDate) {
        this.id = id;
        this.personId = personId;
        this.personPin = personPin;
        this.personName = personName;
        this.personLastName = personLastName;
        this.deptId = deptId;
        this.deptCode = deptCode;
        this.deptName = deptName;
        this.accountNo = accountNo;
        this.balance = balance;
        this.password = password;
        this.serialNum = serialNum;
        this.issueDate = issueDate;
        this.available = isValid;
        this.status = status;
        this.posDate = posDate;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public Double getBalance() {
        return this.balance;
    }

    public Double getPosMoneyWallet() {
        return this.posMoneyWallet;
    }

    public Double getPosAllowanceWallet() {
        return this.posAllowanceWallet;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Integer getAccountType() {
        return this.accountType;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getSerialNum() {
        return this.serialNum;
    }

    public Integer getAvailable() {
        return this.available;
    }

    public Integer getAccountMember() {
        return this.accountMember;
    }

    public Date getPosDate() {
        return this.posDate;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPosAccountKindId() {
        return this.posAccountKindId;
    }

    public String getAccountKindName() {
        return this.accountKindName;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public PosIDAccountExportItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosIDAccountExportItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosIDAccountExportItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosIDAccountExportItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosIDAccountExportItem setAccountNo(String accountNo) {
        this.accountNo = accountNo;
        return this;
    }

    public PosIDAccountExportItem setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public PosIDAccountExportItem setName(String name) {
        this.name = name;
        return this;
    }

    public PosIDAccountExportItem setBalance(Double balance) {
        this.balance = balance;
        return this;
    }

    public PosIDAccountExportItem setPosMoneyWallet(Double posMoneyWallet) {
        this.posMoneyWallet = posMoneyWallet;
        return this;
    }

    public PosIDAccountExportItem setPosAllowanceWallet(Double posAllowanceWallet) {
        this.posAllowanceWallet = posAllowanceWallet;
        return this;
    }

    public PosIDAccountExportItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PosIDAccountExportItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosIDAccountExportItem setAccountType(Integer accountType) {
        this.accountType = accountType;
        return this;
    }

    public PosIDAccountExportItem setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    public PosIDAccountExportItem setPassword(String password) {
        this.password = password;
        return this;
    }

    public PosIDAccountExportItem setSerialNum(Integer serialNum) {
        this.serialNum = serialNum;
        return this;
    }

    public PosIDAccountExportItem setAvailable(Integer available) {
        this.available = available;
        return this;
    }

    public PosIDAccountExportItem setAccountMember(Integer accountMember) {
        this.accountMember = accountMember;
        return this;
    }

    public PosIDAccountExportItem setPosDate(Date posDate) {
        this.posDate = posDate;
        return this;
    }

    public PosIDAccountExportItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosIDAccountExportItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosIDAccountExportItem setPosAccountKindId(String posAccountKindId) {
        this.posAccountKindId = posAccountKindId;
        return this;
    }

    public PosIDAccountExportItem setAccountKindName(String accountKindName) {
        this.accountKindName = accountKindName;
        return this;
    }

    public PosIDAccountExportItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public PosIDAccountExportItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosIDAccountExportItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String toString() {
        return "PosIDAccountExportItem(id=" + this.getId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", accountNo=" + this.getAccountNo() + ", status=" + this.getStatus() + ", name=" + this.getName() + ", balance=" + this.getBalance() + ", posMoneyWallet=" + this.getPosMoneyWallet() + ", posAllowanceWallet=" + this.getPosAllowanceWallet() + ", deptCode=" + this.getDeptCode() + ", deptName=" + this.getDeptName() + ", accountType=" + this.getAccountType() + ", issueDate=" + this.getIssueDate() + ", password=" + this.getPassword() + ", serialNum=" + this.getSerialNum() + ", available=" + this.getAvailable() + ", accountMember=" + this.getAccountMember() + ", posDate=" + this.getPosDate() + ", deptId=" + this.getDeptId() + ", personId=" + this.getPersonId() + ", posAccountKindId=" + this.getPosAccountKindId() + ", accountKindName=" + this.getAccountKindName() + ", notInId=" + this.getNotInId() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ")";
    }
}

