/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.base.config.I18nCookieLocaleResolver;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.support.RequestContextUtils;

public class I18nUtil {
    private static Pattern pattern = Pattern.compile("\\$\\{[\\w\\.-]+}");

    public static ZKResultMsg i18nMsg(ZKResultMsg msg) {
        LocaleMessageSourceUtil localeMessageSource;
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        if (ra != null) {
            HttpServletRequest req = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HttpServletResponse resp = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
            if (req != null) {
                RequestContext rc = new RequestContext(req, resp, req.getServletContext(), null);
                msg.setMsg(rc.getMessage(msg.getMsg(), msg.getI18nArgs()));
                return msg;
            }
        }
        if (Objects.isNull(localeMessageSource = SpringContextUtil.getBean(LocaleMessageSourceUtil.class))) {
            return msg;
        }
        msg.setMsg(localeMessageSource.getMessage(msg.getMsg(), msg.getI18nArgs()));
        return msg;
    }

    public static String i18nCode(String code, Object ... args) {
        LocaleMessageSourceUtil localeMessageSource;
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        if (ra != null) {
            HttpServletRequest req = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HttpServletResponse resp = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
            if (req != null) {
                LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)req);
                if (localeResolver == null) {
                    req.setAttribute(DispatcherServlet.LOCALE_RESOLVER_ATTRIBUTE, (Object)new I18nCookieLocaleResolver());
                }
                RequestContext rc = new RequestContext(req, resp, req.getServletContext(), null);
                return rc.getMessage(code, args);
            }
        }
        if (Objects.isNull(localeMessageSource = SpringContextUtil.getBean(LocaleMessageSourceUtil.class))) {
            return code;
        }
        return localeMessageSource.getMessage(code, args);
    }

    public static String i18nText(String msg) {
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            Matcher matcher = pattern.matcher(msg);
            while (matcher.find()) {
                String code = matcher.group();
                code = code.substring(2, code.length() - 1);
                msg = msg.replace("${" + code + "}", I18nUtil.i18nCode(code, new Object[0]));
            }
        }
        return msg;
    }
}

