/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.core.utils;

import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Deprecated
@Component
public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    public static final char separator = '/';
    public static final String uploadFilePath = "upload";
    public static final String thumbPath = "thumb";
    public static final String cropFacePath = "cropface";
    public static String systemFilePath;

    @Value(value="${system.filePath:BioSecurityFile}")
    public void setSystemFilePath(String systemFilePath) {
        FileUtil.systemFilePath = systemFilePath;
    }

    public static String createUploadFileRootPath(String module, String business) {
        return "upload/" + module + '/' + business + '/' + DateUtil.dateToString(new Date(), DateUtil.DateStyle.YYYY_MM_DD) + '/';
    }

    public static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
            return true;
        }
        return false;
    }

    public static void saveFile(String filePath, String fileName, MultipartFile uploadFile) {
        try {
            if (Objects.nonNull(uploadFile) && !uploadFile.isEmpty()) {
                String fullPath = systemFilePath + '/' + filePath;
                File file = new File(new File(fullPath), fileName);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (file.exists()) {
                    file.delete();
                }
                uploadFile.transferTo(new File(file.getAbsolutePath()));
                FileUtil.createThumbPic(file, filePath, fileName);
            }
        }
        catch (Exception e) {
            new ZKBusinessException("-------------  Save  File  Error :" + e.getMessage());
        }
    }

    public static void createThumbPic(File originalFile, String filePath, String fileName) throws IOException {
        if (fileName.toLowerCase().matches(".*?(jpg|jpeg|png|bmp|gif)")) {
            String fullThumbPath = systemFilePath + '/' + filePath + '/' + thumbPath;
            File thumbFile = new File(new File(fullThumbPath), fileName = fileName.substring(0, fileName.lastIndexOf(".")) + ".jpg");
            if (!thumbFile.getParentFile().exists()) {
                thumbFile.getParentFile().mkdirs();
            }
            if (thumbFile.exists()) {
                thumbFile.delete();
            }
            ImgEncodeUtil.createZoomImage(originalFile, thumbFile);
        }
    }

    public static String getLocalFullPath(String relativePath) {
        String fullPath = systemFilePath + '/' + relativePath;
        File file = new File(fullPath);
        return file.getAbsolutePath();
    }

    public static boolean fileExists(String relativePath) {
        String fullPath = systemFilePath + '/' + relativePath;
        File file = new File(fullPath);
        return file.exists();
    }

    public static String getThumbPath(String originalFilePath) {
        if (StringUtils.hasLength((String)originalFilePath)) {
            int index = originalFilePath.lastIndexOf(47);
            if (index != -1 && !originalFilePath.startsWith("http")) {
                return originalFilePath.substring(0, index) + '/' + thumbPath + originalFilePath.substring(index);
            }
            return originalFilePath;
        }
        return null;
    }

    public static String getCropFacePath(String pin) {
        if (StringUtils.hasLength((String)pin)) {
            return "upload/pers/user/cropface/" + pin;
        }
        return null;
    }

    public static int getCropFaceCount() {
        int cropFaceCount = 0;
        File file = new File(systemFilePath + '/' + uploadFilePath + '/' + "pers/user" + '/' + cropFacePath);
        if (file.exists()) {
            for (File f : file.listFiles()) {
                cropFaceCount += f.listFiles().length;
            }
        }
        return cropFaceCount;
    }

    public static String getCropFacePath(String business, String fileName) {
        if (StringUtils.hasLength((String)fileName)) {
            return "upload/" + business + '/' + cropFacePath + '/' + fileName;
        }
        return null;
    }

    public static int getCropFaceCount(String pin) {
        File file = new File(systemFilePath + '/' + FileUtil.getCropFacePath(pin));
        if (file.exists()) {
            return file.listFiles().length;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(String filePath, String fileName, String base64ImgStr, boolean thumbPic) {
        OutputStream out = null;
        try {
            String fullPath = systemFilePath + '/' + filePath;
            File file = new File(new File(fullPath), fileName);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            out = new FileOutputStream(file);
            out.write(Base64.getDecoder().decode(base64ImgStr));
            out.flush();
            out.close();
            if (thumbPic) {
                FileUtil.createThumbPic(file, filePath, fileName);
            }
        }
        catch (Exception e) {
            new ZKBusinessException("-------------  Save  File  Error :" + e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String saveFileToServer(String module, String business, String fileName, MultipartFile uploadFile) {
        if (StringUtils.hasLength((String)fileName)) {
            String filePath = FileUtil.createUploadFileRootPath(module, business);
            FileUtil.saveFile(filePath, fileName, uploadFile);
            fileName = '/' + filePath + fileName;
        }
        return fileName;
    }

    public static String saveFileToServer(String module, String business, String fileName, String base64ImgStr) {
        if (StringUtils.hasLength((String)fileName)) {
            String filePath = FileUtil.createUploadFileRootPath(module, business);
            FileUtil.saveFile(filePath, fileName, base64ImgStr, true);
            fileName = '/' + filePath + fileName;
        }
        return fileName;
    }

    public static String saveCropFaceToServer(String pin, String fileName, String base64ImgStr) {
        if (StringUtils.hasLength((String)pin)) {
            String filePath = FileUtil.getCropFacePath(pin);
            FileUtil.saveFile(filePath, fileName, base64ImgStr, false);
            fileName = '/' + filePath + '/' + fileName;
        }
        return fileName;
    }

    public static String getFileSize(MultipartFile file) {
        DecimalFormat df = new DecimalFormat("#.##");
        String fileSiz = file.getSize() / 1024L > 1000L ? df.format((double)file.getSize() / 1024.0 / 1024.0) + "MB" : df.format(file.getSize() / 1024L);
        return fileSiz;
    }

    public static String getFileMd5Value(String filePath) {
        try {
            return DigestUtils.md5Hex((InputStream)new FileInputStream(filePath));
        }
        catch (IOException e) {
            throw new ZKBusinessException("-------------  File Path Error :" + e.getMessage());
        }
    }

    public static String getFileBase64Str(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return "";
        }
        FileInputStream inputFile = null;
        try {
            inputFile = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            inputFile.read(buffer);
            String string = Base64.getEncoder().encodeToString(buffer);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("-------------  File Path Error :" + e.getMessage());
        }
        finally {
            try {
                if (Objects.nonNull(inputFile)) {
                    inputFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean deleteDirectory(String dir) {
        File dirFile;
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if (!(dirFile = new File(dir)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = FileUtil.deleteFile(files[i].getAbsolutePath())) : !(flag = FileUtil.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
            }
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpServletResponse downLoadFiles(String tempPath, File[] files, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ZipOutputStream zipOut = null;
        FileOutputStream fileOutputStr = null;
        try {
            File file = new File(tempPath);
            if (!file.exists()) {
                file.createNewFile();
            }
            response.reset();
            fileOutputStr = new FileOutputStream(file);
            zipOut = new ZipOutputStream(fileOutputStr);
            FileUtil.zipFiles(files, zipOut);
            zipOut.close();
            fileOutputStr.close();
            HttpServletResponse httpServletResponse = FileUtil.downloadZip(file, response);
            return httpServletResponse;
        }
        catch (Exception e) {
            logger.error("exception:", (Throwable)e);
        }
        finally {
            if (zipOut != null) {
                zipOut.close();
            }
            if (fileOutputStr != null) {
                fileOutputStr.close();
            }
        }
        return response;
    }

    public static void zipFiles(File[] files, ZipOutputStream outputStream) {
        int size = files.length;
        for (int i = 0; i < size; ++i) {
            FileUtil.zipFile(files[i], outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(File inputFile, ZipOutputStream ouputStream) {
        block25: {
            FileInputStream inputStream = null;
            BufferedInputStream bufferInput = null;
            try {
                if (!inputFile.exists()) break block25;
                if (inputFile.isFile()) {
                    int index;
                    inputStream = new FileInputStream(inputFile);
                    bufferInput = new BufferedInputStream(inputStream, 512);
                    ZipEntry entry = new ZipEntry(inputFile.getName());
                    ouputStream.putNextEntry(entry);
                    byte[] buffer = new byte[512];
                    while ((index = bufferInput.read(buffer)) != -1) {
                        ouputStream.write(buffer, 0, index);
                    }
                    bufferInput.close();
                    inputStream.close();
                    break block25;
                }
                try {
                    File[] files = inputFile.listFiles();
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            FileUtil.zipFile(files[i], ouputStream, inputFile.getName());
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("exception:", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("exception:", (Throwable)e);
            }
            finally {
                if (bufferInput != null) {
                    try {
                        bufferInput.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(File inputFile, ZipOutputStream ouputStream, String path) {
        block25: {
            FileInputStream inputStream = null;
            BufferedInputStream bufferInput = null;
            try {
                if (!inputFile.exists()) break block25;
                if (inputFile.isFile()) {
                    int index;
                    inputStream = new FileInputStream(inputFile);
                    bufferInput = new BufferedInputStream(inputStream, 512);
                    ZipEntry entry = new ZipEntry(path + File.separator + inputFile.getName());
                    ouputStream.putNextEntry(entry);
                    byte[] buffer = new byte[512];
                    while ((index = bufferInput.read(buffer)) != -1) {
                        ouputStream.write(buffer, 0, index);
                    }
                    bufferInput.close();
                    inputStream.close();
                    break block25;
                }
                try {
                    File[] files = inputFile.listFiles();
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            FileUtil.zipFile(files[i], ouputStream, path + File.separator + inputFile.getName());
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("exception:", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("exception:", (Throwable)e);
            }
            finally {
                if (bufferInput != null) {
                    try {
                        bufferInput.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpServletResponse downloadZip(File file, HttpServletResponse response) {
        InputStream fis = null;
        OutputStream toClient = null;
        try {
            fis = new BufferedInputStream(new FileInputStream(file.getPath()));
            response.reset();
            toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + file.getName());
            byte[] buffer = new byte[1024];
            int i = -1;
            while ((i = fis.read(buffer)) != -1) {
                toClient.write(buffer, 0, i);
            }
            fis.close();
            toClient.flush();
            toClient.close();
        }
        catch (IOException ex) {
            logger.error("exception:", (Throwable)ex);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (toClient != null) {
                    toClient.close();
                }
            }
            catch (Exception e) {
                logger.error("exception:", (Throwable)e);
            }
        }
        return response;
    }

    public static void saveMultipartFile(String filePath, String fileName, MultipartFile uploadFile, boolean thumbPic) {
        try {
            if (Objects.nonNull(uploadFile) && !uploadFile.isEmpty()) {
                String fullPath = systemFilePath + '/' + filePath;
                File file = new File(new File(fullPath), fileName);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (file.exists()) {
                    file.delete();
                }
                uploadFile.transferTo(new File(file.getAbsolutePath()));
                if (thumbPic) {
                    FileUtil.createThumbPic(file, filePath, fileName);
                }
            }
        }
        catch (Exception e) {
            new ZKBusinessException("-------------  Save  File  Error :" + e.getMessage());
        }
    }
}

